/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.render.entity;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;

public class ModelPositions {
    private EntityModel entityModel;
    private Map<ModelPart, PartPose> positionMap = new HashMap<ModelPart, PartPose>();

    public ModelPositions(EntityModel entityModel) {
        this.entityModel = entityModel;
        this.updateDefaultPositions();
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            ModelPositions.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public void updateDefaultPositions() {
        List<Field> fields = ModelPositions.getAllFields(new LinkedList<Field>(), this.entityModel.getClass());
        try {
            for (Field f : fields) {
                f.setAccessible(true);
                Object object = f.get(this.entityModel);
                if (!(object instanceof ModelPart)) continue;
                ModelPart part = (ModelPart)object;
                this.positionMap.put(part, PartPose.m_171423_((float)part.f_104200_, (float)part.f_104201_, (float)part.f_104202_, (float)part.f_104203_, (float)part.f_104204_, (float)part.f_104205_));
            }
        }
        catch (Exception e) {
            IWannaSkateMod.LOGGER.warn("could not save default position of model[" + this.entityModel.getClass().getSimpleName() + "] for animating on a skateboard.");
            e.printStackTrace();
        }
    }

    public void resetDefaultPositions() {
        this.positionMap.forEach((modelPart, modelPosition) -> this.updatePart((ModelPart)modelPart, (PartPose)modelPosition));
    }

    public boolean isFor(EntityModel model) {
        return this.entityModel == model;
    }

    private void updatePart(ModelPart modelPart, PartPose modelPosition) {
        modelPart.f_104200_ = modelPosition.f_171405_;
        modelPart.f_104201_ = modelPosition.f_171406_;
        modelPart.f_104202_ = modelPosition.f_171407_;
        modelPart.f_104203_ = modelPosition.f_171408_;
        modelPart.f_104204_ = modelPosition.f_171409_;
        modelPart.f_104205_ = modelPosition.f_171410_;
    }
}

