/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.client.model.HasHeadModelParts;
import com.github.alexthe668.iwannaskate.client.model.ModelPartType;
import com.github.alexthe668.iwannaskate.client.model.ModelPartWrapper;
import com.github.alexthe668.iwannaskate.client.model.SkateModelMapping;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;

public class ModelRootRegistry
implements ResourceManagerReloadListener {
    private static Map<ResourceLocation, ModelPart> BAKED_ID_TO_ROOT_PART = new HashMap<ResourceLocation, ModelPart>();
    private static Map<EntityModel, ResourceLocation> MODEL_TO_BAKED_ID = new HashMap<EntityModel, ResourceLocation>();
    private static List<SkateModelMapping> ALL_MAPPINGS = new ArrayList<SkateModelMapping>();
    private static Map<EntityModel, SkateModelParts> MODEL_TO_ANIMATING_PARTS = new HashMap<EntityModel, SkateModelParts>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(SkateModelMapping.class, (Object)new SkateModelMapping.Deserializer()).create();
    private ResourceLocation lastBaked = null;
    public static ModelRootRegistry INSTANCE = new ModelRootRegistry();

    private ModelRootRegistry() {
        this.reload(Minecraft.m_91087_().m_91098_());
    }

    public static void onCallBakeLayer(ModelLayerLocation modelLocation, ModelPart root) {
        if (modelLocation.m_171124_().equals("main")) {
            BAKED_ID_TO_ROOT_PART.put(modelLocation.m_171123_(), root);
            ModelRootRegistry.INSTANCE.lastBaked = modelLocation.m_171123_();
        }
    }

    public static void onConstructRenderer(EntityModel model) {
        if (ModelRootRegistry.INSTANCE.lastBaked != null) {
            MODEL_TO_BAKED_ID.put(model, ModelRootRegistry.INSTANCE.lastBaked);
            ModelRootRegistry.INSTANCE.lastBaked = null;
        }
    }

    private void reload(ResourceManager manager) {
        ALL_MAPPINGS.clear();
        MODEL_TO_ANIMATING_PARTS.clear();
        int emptyMappingsCount = 0;
        Set collection = manager.m_214159_("skate_model_mappings", resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).keySet();
        for (ResourceLocation res : collection) {
            try {
                Optional resource = manager.m_213713_(res);
                if (!resource.isPresent()) continue;
                BufferedReader inputstream = ((Resource)resource.get()).m_215508_();
                try {
                    SkateModelMapping mapping = (SkateModelMapping)GsonHelper.m_13776_((Gson)GSON, (Reader)inputstream, SkateModelMapping.class);
                    ALL_MAPPINGS.add(mapping);
                }
                catch (JsonParseException parseException) {
                    ++emptyMappingsCount;
                }
            }
            catch (Exception e) {
                IWannaSkateMod.LOGGER.error("Could not load skate model mappings for " + res);
                e.printStackTrace();
            }
        }
        IWannaSkateMod.LOGGER.info("Loaded {} model mappings for skating animations", (Object)ALL_MAPPINGS.size());
        if (emptyMappingsCount > 0) {
            IWannaSkateMod.LOGGER.info("Skipping {} model mappings because their entity type does not exist, likely because a compatible mod is not installed", (Object)emptyMappingsCount);
        }
    }

    public void m_6213_(ResourceManager manager) {
        this.reload(manager);
    }

    @Nullable
    private ModelPart getRootForModel(EntityModel model) {
        if (MODEL_TO_BAKED_ID.containsKey(model)) {
            return BAKED_ID_TO_ROOT_PART.get(MODEL_TO_BAKED_ID.get(model));
        }
        return null;
    }

    public List<ModelPartWrapper> getVanillaModelPartFromRoot(EntityModel model, ModelPart root, SkateModelMapping mapping, ModelPartType type) {
        ArrayList parts = Lists.newArrayList();
        for (String partName : mapping.getListForType(type)) {
            try {
                if (type == ModelPartType.HEAD && model instanceof HasHeadModelParts) {
                    HasHeadModelParts listModel = (HasHeadModelParts)model;
                    listModel.getHeadModelParts().forEach(part -> parts.add(new ModelPartWrapper((ModelPart)part)));
                    continue;
                }
                boolean isRoot = partName.equals("root") && type == ModelPartType.BODY;
                ModelPart part2 = isRoot ? root : this.getNestedChildPart(root, partName);
                if (part2 == null) continue;
                parts.add(new ModelPartWrapper(part2, isRoot));
            }
            catch (NoSuchElementException exception) {
                IWannaSkateMod.LOGGER.warn("Error animating model {} : {}", model.getClass(), (Object)exception.getMessage());
            }
        }
        return parts;
    }

    public List<ModelPartWrapper> getAdvancedModelPartFromRoot(AdvancedEntityModel model, SkateModelMapping mapping, ModelPartType type) {
        ArrayList parts = Lists.newArrayList();
        for (String partName : mapping.getListForType(type)) {
            try {
                for (AdvancedModelBox box : model.getAllParts()) {
                    if (box.boxName == null || !box.boxName.equals(partName)) continue;
                    parts.add(new ModelPartWrapper(box));
                }
            }
            catch (NoSuchElementException exception) {
                IWannaSkateMod.LOGGER.warn("Error animating model:" + exception.getMessage());
            }
        }
        return parts;
    }

    private ModelPart getNestedChildPart(ModelPart root, String partName) {
        if (root.m_233562_(partName)) {
            return root.m_171324_(partName);
        }
        List allParts = root.m_171331_().toList();
        for (ModelPart inAll : allParts) {
            if (!inAll.m_233562_(partName)) continue;
            return inAll.m_171324_(partName);
        }
        return null;
    }

    @Nullable
    public SkateModelParts getAnimationData(EntityModel model, EntityType<?> entityType) {
        MODEL_TO_ANIMATING_PARTS.clear();
        if (MODEL_TO_ANIMATING_PARTS.containsKey(model)) {
            return MODEL_TO_ANIMATING_PARTS.get(model);
        }
        SkateModelMapping mapping = this.getMappingForEntity(entityType);
        int i = 0;
        float strength = 1.0f;
        float speed = 1.0f;
        boolean faceForwards = false;
        ModelPartWrapper[][] allPartsForAnim = new ModelPartWrapper[6][];
        if (mapping != null) {
            strength = mapping.getStrength();
            speed = mapping.getSpeed();
            faceForwards = mapping.isFaceForwards();
            if (model instanceof AdvancedEntityModel) {
                AdvancedEntityModel advancedEntityModel = (AdvancedEntityModel)model;
                for (ModelPartType partType : ModelPartType.values()) {
                    List<ModelPartWrapper> modelParts = this.getAdvancedModelPartFromRoot(advancedEntityModel, mapping, partType);
                    allPartsForAnim[i++] = modelParts.toArray(new ModelPartWrapper[0]);
                }
            } else {
                ModelPart root = this.getRootForModel(model);
                if (root != null) {
                    for (ModelPartType partType : ModelPartType.values()) {
                        List<ModelPartWrapper> modelParts = this.getVanillaModelPartFromRoot(model, root, mapping, partType);
                        allPartsForAnim[i++] = modelParts.toArray(new ModelPartWrapper[0]);
                    }
                }
            }
            SkateModelParts animatedParts = new SkateModelParts(allPartsForAnim[0], allPartsForAnim[1], allPartsForAnim[2], allPartsForAnim[3], allPartsForAnim[4], allPartsForAnim[5], strength, speed, faceForwards);
            MODEL_TO_ANIMATING_PARTS.put(model, animatedParts);
            return animatedParts;
        }
        MODEL_TO_ANIMATING_PARTS.put(model, null);
        return null;
    }

    public SkateModelMapping getMappingForEntity(EntityType<?> entityType) {
        SkateModelMapping mapping = null;
        for (SkateModelMapping compareTo : ALL_MAPPINGS) {
            if (!compareTo.matchesEntityType(entityType)) continue;
            mapping = compareTo;
            break;
        }
        return mapping;
    }

    public record SkateModelParts(ModelPartWrapper[] body, ModelPartWrapper[] head, ModelPartWrapper[] rightArm, ModelPartWrapper[] leftArm, ModelPartWrapper[] rightLeg, ModelPartWrapper[] leftLeg, float strength, float speed, boolean faceForwards) {
    }
}

