/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.color;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class BoardColorSampler {
    private static final int COLORS_TO_SAMPLE = 4;
    private static final int[] DEFAULT_COLORS = new int[]{12754274, 12096607, 11505493, 10454093};
    public static Map<ResourceLocation, int[]> TEXTURES_TO_COLOR = new HashMap<ResourceLocation, int[]>();

    public static void sampleColorsOnLoad() {
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(IWSTags.SAMPLE_COLORS_ON_LOAD)).forEach(BoardColorSampler::getColor);
    }

    public static int[] getColor(ResourceLocation item) {
        return BoardColorSampler.getColor((Item)ForgeRegistries.ITEMS.getValue(item));
    }

    public static int[] getColor(Item item) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name == null) {
            return DEFAULT_COLORS;
        }
        if (TEXTURES_TO_COLOR.get(name) != null) {
            return TEXTURES_TO_COLOR.get(name);
        }
        int colorizer = -1;
        try {
            colorizer = Minecraft.m_91087_().getItemColors().m_92676_(new ItemStack((ItemLike)item), 0);
        }
        catch (Exception e) {
            IWannaSkateMod.LOGGER.warn("Another mod did not use item colorizers correctly.");
        }
        int[] colors = new int[4];
        try {
            List<Integer> gatherAllColors = BoardColorSampler.gatherAllColors(BoardColorSampler.getTextureAtlasSprite(item));
            if (gatherAllColors.isEmpty()) {
                colors = DEFAULT_COLORS;
            } else {
                for (int i = 0; i < 4; ++i) {
                    int color = 0;
                    color = gatherAllColors.size() < i + 1 ? gatherAllColors.get(i - 1).intValue() : gatherAllColors.get(i).intValue();
                    colors[i] = color;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            colors = DEFAULT_COLORS;
        }
        TEXTURES_TO_COLOR.put(name, colors);
        return colors;
    }

    private static List<Integer> gatherAllColors(TextureAtlasSprite image) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        int uMax = image.m_245424_().m_246492_();
        int vMax = image.m_245424_().m_245330_();
        for (float i = 0.0f; i < (float)uMax; i += 1.0f) {
            for (float j = 0.0f; j < (float)vMax; j += 1.0f) {
                int color = image.getPixelRGBA(0, (int)i, (int)j);
                int alpha = color >> 24 & 0xFF;
                if (alpha == 0 || colors.contains(color)) continue;
                colors.add(color);
            }
        }
        Collections.sort(colors, (a, b) -> Integer.compare(b, a));
        return colors;
    }

    private static TextureAtlasSprite getTextureAtlasSprite(Item itemStack) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(itemStack).getParticleIcon(ModelData.EMPTY);
    }
}

