/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.item.InstrumentItem;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="genshinstrument")
public abstract class ServerEvents {
    private static final int MAX_BLOCK_INSTRUMENT_DIST = 6;

    @SubscribeEvent
    public static void onServerTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            event.level.m_6907_().forEach(player -> {
                if (ServerEvents.shouldAbruptlyClose(player)) {
                    InstrumentPacketUtil.setInstrumentClosed((ServerPlayer)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        InstrumentPacketUtil.setInstrumentClosed((ServerPlayer)event.getEntity());
    }

    private static boolean shouldAbruptlyClose(Player player) {
        if (!InstrumentOpenProvider.isOpen(player)) {
            return false;
        }
        if (InstrumentOpenProvider.isItem(player)) {
            InteractionHand hand = InstrumentOpenProvider.getHand(player);
            if (hand == null) {
                return true;
            }
            ItemStack handItem = player.m_21120_(hand);
            return !(handItem.m_41720_() instanceof InstrumentItem);
        }
        return !InstrumentOpenProvider.getBlockPos(player).m_203195_((Position)player.m_20182_(), 6.0);
    }
}

