/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.IHeldInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.MidiEvent;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="genshinstrument", value={Dist.CLIENT})
public class ClientEvents {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        InstrumentScreen.getCurrentScreen(MINECRAFT).ifPresent(InstrumentScreen::handleAbruptClosing);
    }

    @SubscribeEvent
    public static void prePlayerRenderEvent(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!InstrumentOpenProvider.isOpen(player) || InstrumentOpenProvider.isItem(player)) {
            return;
        }
        Block block = player.m_9236_().m_8055_(InstrumentOpenProvider.getBlockPos(player)).m_60734_();
        if (!(block instanceof AbstractInstrumentBlock)) {
            return;
        }
        AbstractInstrumentBlock instrumentBlock = (AbstractInstrumentBlock)block;
        PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
        model.f_102815_ = model.f_102816_ = instrumentBlock.getClientBlockArmPose();
    }

    @SubscribeEvent
    public static void onInstrumentPlayed(InstrumentPlayedEvent<?> event) {
        if (!ClientEvents.validateSharedScreen(event)) {
            return;
        }
        if (!event.soundMeta().pos().m_123314_((Vec3i)ClientEvents.MINECRAFT.f_91074_.m_20183_(), 5.5)) {
            return;
        }
        ClientEvents.foreignPlayableInstrumentScreen(event).ifPresent(screen -> screen.foreignPlay(event));
    }

    @SubscribeEvent
    public static void onHeldNoteSound(HeldNoteSoundPlayedEvent event) {
        if (event.phase != HeldSoundPhase.RELEASE) {
            return;
        }
        if (!ClientEvents.validateSharedScreen(event)) {
            return;
        }
        ClientEvents.foreignPlayableInstrumentScreen(event).filter(screen -> screen instanceof IHeldInstrumentScreen).map(screen -> (IHeldInstrumentScreen)((Object)screen)).ifPresent(screen -> screen.releaseForeign(event));
    }

    private static boolean validateSharedScreen(InstrumentPlayedEvent<?> event) {
        Entity initiator;
        if (!event.level().f_46443_) {
            return false;
        }
        if (!((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get()).booleanValue()) {
            return false;
        }
        return !event.isByPlayer() || !(initiator = event.entityInfo().get().entity).equals((Object)ClientEvents.MINECRAFT.f_91074_);
    }

    private static Optional<InstrumentScreen> foreignPlayableInstrumentScreen(InstrumentPlayedEvent<?> event) {
        return InstrumentScreen.getCurrentScreen(MINECRAFT).filter(screen -> event.soundMeta().noteIdentifier().isEmpty() || screen.getInstrumentId().equals((Object)event.soundMeta().instrumentId()));
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        HeldNoteSounds.releaseAll();
    }

    @SubscribeEvent
    public static void onMidiEvent(MidiEvent event) {
        InstrumentScreen.getCurrentScreen(Minecraft.m_91087_()).filter(InstrumentScreen::isMidiInstrument).ifPresent(instrument -> instrument.midiReceiver.onMidi(event));
    }

    @SubscribeEvent
    public static void onGameShutdown(GameShuttingDownEvent event) {
        MidiController.unloadDevice();
    }
}

