/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.util;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.block.partial.IDoubleBlock;
import com.cstav.evenmoreinstruments.capability.recording.RecordingCapabilityProvider;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LooperUtil {
    public static final String LOOPER_TAG = "looper";
    public static final String POS_TAG = "pos";
    private static final Map<String, String> LOOPER_LEGACY_MAPPER = Map.ofEntries(Map.entry("instrumentId", "InstrumentId"), Map.entry("notes", "Notes"), Map.entry("volume", "Volume"), Map.entry("pitch", "Pitch"), Map.entry("soundIndex", "SoundIndex"), Map.entry("soundType", "SoundType"), Map.entry("timestamp", "Timestamp"), Map.entry("recording", "Recording"), Map.entry("ticks", "Ticks"), Map.entry("channel", "Channel"), Map.entry("repeatTick", "RepeatTick"));

    public static boolean hasLooperTag(ItemStack instrument) {
        return LooperUtil.hasLooperTag(EMIMain.modTag(instrument));
    }

    public static boolean hasLooperTag(BlockEntity instrument) {
        return LooperUtil.hasLooperTag(EMIMain.modTag(instrument));
    }

    private static boolean hasLooperTag(CompoundTag modTag) {
        return modTag.m_128425_(LOOPER_TAG, 10) && !modTag.m_128469_(LOOPER_TAG).m_128456_();
    }

    public static void remLooperTag(ItemStack instrument) {
        EMIMain.modTag(instrument).m_128473_(LOOPER_TAG);
    }

    public static void remLooperTag(BlockEntity instrument) {
        EMIMain.modTag(instrument).m_128473_(LOOPER_TAG);
    }

    public static void createLooperTag(ItemStack instrument, BlockPos looperPos) {
        EMIMain.modTag(instrument).m_128365_(LOOPER_TAG, (Tag)new CompoundTag());
        LooperUtil.constructLooperTag(LooperUtil.looperTag(instrument), looperPos);
    }

    public static void createLooperTag(BlockEntity instrument, BlockPos looperPos) {
        EMIMain.modTag(instrument).m_128365_(LOOPER_TAG, (Tag)new CompoundTag());
        LooperUtil.constructLooperTag(LooperUtil.looperTag(instrument), looperPos);
    }

    private static void constructLooperTag(CompoundTag looperTag, BlockPos looperPos) {
        looperTag.m_128365_(POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)looperPos));
    }

    public static CompoundTag looperTag(ItemStack instrument) {
        return LooperUtil.looperTag(EMIMain.modTag(instrument));
    }

    public static CompoundTag looperTag(BlockEntity instrument) {
        return LooperUtil.looperTag(EMIMain.modTag(instrument));
    }

    public static CompoundTag looperTag(CompoundTag parentTag) {
        return parentTag.m_128425_(LOOPER_TAG, 10) ? parentTag.m_128469_(LOOPER_TAG) : new CompoundTag();
    }

    public static CompoundTag getLooperTagFromEvent(InstrumentPlayedEvent<?> event) {
        if (!event.isByPlayer()) {
            return new CompoundTag();
        }
        InstrumentPlayedEvent.EntityInfo entityInfo = (InstrumentPlayedEvent.EntityInfo)event.entityInfo().get();
        Player player = (Player)entityInfo.entity;
        return !entityInfo.isBlockInstrument() ? LooperUtil.looperTag(player.m_21120_((InteractionHand)entityInfo.hand.get())) : LooperUtil.looperTag(event.level().m_7702_(event.soundMeta().pos()));
    }

    @Nullable
    public static LooperBlockEntity getFromEvent(InstrumentPlayedEvent<?> event) {
        if (!event.isByPlayer()) {
            return null;
        }
        InstrumentPlayedEvent.EntityInfo entityInfo = (InstrumentPlayedEvent.EntityInfo)event.entityInfo().get();
        Player player = (Player)entityInfo.entity;
        Level level = event.level();
        if (entityInfo.isItemInstrument()) {
            return LooperUtil.getFromItemInstrument(level, player.m_21120_((InteractionHand)entityInfo.hand.get()));
        }
        if (entityInfo.isBlockInstrument()) {
            return LooperUtil.getFromBlockInstrument(level, level.m_7702_(event.soundMeta().pos()));
        }
        return null;
    }

    @Nullable
    public static LooperBlockEntity getFromItemInstrument(Level level, ItemStack instrument) {
        return LooperUtil.getFromInstrument(level, LooperUtil.looperTag(instrument), () -> LooperUtil.remLooperTag(instrument));
    }

    @Nullable
    public static LooperBlockEntity getFromBlockInstrument(Level level, BlockEntity instrument) {
        return LooperUtil.getFromInstrument(level, LooperUtil.looperTag(instrument), () -> {
            LooperUtil.remLooperTag(instrument);
            BlockPos pos = instrument.m_58899_();
            BlockState state = level.m_8055_(pos);
            Block patt4866$temp = state.m_60734_();
            if (patt4866$temp instanceof IDoubleBlock) {
                IDoubleBlock doubleBlock = (IDoubleBlock)patt4866$temp;
                LooperUtil.remLooperTag(level.m_7702_(doubleBlock.getOtherBlock(state, pos, level)));
            }
        });
    }

    @Nullable
    private static LooperBlockEntity getFromInstrument(Level level, CompoundTag looperData, Runnable onInvalid) {
        if (looperData.m_128456_()) {
            return null;
        }
        LooperBlockEntity looperBE = LooperUtil.getFromPos(level, LooperUtil.getLooperPos(looperData));
        if (looperBE == null) {
            onInvalid.run();
        }
        return looperBE;
    }

    public static LooperBlockEntity getFromPos(Level level, BlockPos pos) {
        LooperBlockEntity lbe;
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof LooperBlockEntity ? (lbe = (LooperBlockEntity)blockEntity) : null;
    }

    public static boolean performPair(LooperBlockEntity lbe, Runnable pairPerformer, Player pairingPlayer) {
        if (!LooperUtil.validateFootagePresence(lbe, pairingPlayer)) {
            return false;
        }
        pairPerformer.run();
        pairingPlayer.m_5661_((Component)Component.m_237115_((String)"item.evenmoreinstruments.looper_adapter.instrument.success_pair").m_130940_(ChatFormatting.GREEN), true);
        return true;
    }

    public static boolean validateFootagePresence(LooperBlockEntity lbe, Player pairingPlayer) {
        if (!lbe.hasFootage()) {
            return true;
        }
        pairingPlayer.m_5661_((Component)Component.m_237115_((String)"evenmoreinstruments.looper.pair_conflict").m_130940_(ChatFormatting.GREEN), true);
        return false;
    }

    public static boolean isSameBlock(CompoundTag looperTag, BlockPos pos) {
        try {
            return LooperUtil.getLooperPos(looperTag).equals((Object)pos);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Nullable
    public static BlockPos getLooperPos(CompoundTag looperTag) {
        CompoundTag looperPosTag = looperTag.m_128469_(POS_TAG);
        return looperPosTag == null ? null : NbtUtils.m_129239_((CompoundTag)looperPosTag);
    }

    public static void setRecording(Player player, BlockPos looperPos) {
        RecordingCapabilityProvider.setRecording(player, looperPos);
    }

    public static void setNotRecording(Player player) {
        RecordingCapabilityProvider.setNotRecording(player);
    }

    public static boolean isRecording(Player player) {
        return RecordingCapabilityProvider.isRecording(player);
    }

    public static Optional<CompoundTag> migrateLegacyLooper(LooperBlockEntity lbe) {
        CompoundTag lbed = lbe.getPersistentData();
        if (!lbed.m_128425_("channel", 10)) {
            return Optional.empty();
        }
        CompoundTag looperData = CommonUtil.deepConvertCompound(lbed, LOOPER_LEGACY_MAPPER);
        CompoundTag channel = looperData.m_128469_("Channel");
        looperData.m_128379_("Writable", false);
        CommonUtil.moveTags(looperData, channel, "RepeatTick");
        lbed.m_128431_().stream().toList().forEach(arg_0 -> ((CompoundTag)lbed).m_128473_(arg_0));
        looperData.m_128431_().stream().filter(key -> !key.equals("Channel")).forEach(key -> lbed.m_128365_(key, looperData.m_128423_(key)));
        return Optional.of(channel);
    }
}

