/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.client.gui.instrument;

import com.cstav.evenmoreinstruments.client.KeyMappings;
import com.cstav.evenmoreinstruments.mixins.required.ScreenAccessor;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.DoesLooperExistPacket;
import com.cstav.evenmoreinstruments.networking.packet.LooperRecordStatePacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="evenmoreinstruments", value={Dist.CLIENT})
public class LooperOverlayInjector {
    private static final int REC_BTN_WIDTH = 120;
    private static InstrumentScreen screen = null;
    private static boolean isRecording = false;
    private static Button recordBtn;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof InstrumentScreen)) {
            return;
        }
        InstrumentScreen instrumentScreen = (InstrumentScreen)screen;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (InstrumentOpenProvider.isItem((Player)player)) {
            InteractionHand hand = InstrumentOpenProvider.getHand((Player)player);
            ItemStack instrumentItem = player.m_21120_(hand);
            if (!LooperUtil.hasLooperTag(instrumentItem)) {
                return;
            }
            EMIPacketHandler.sendToServer(new DoesLooperExistPacket(hand));
        } else {
            BlockPos instrumentBlockPos = InstrumentOpenProvider.getBlockPos((Player)player);
            BlockEntity instrumentBE = player.m_9236_().m_7702_(instrumentBlockPos);
            if (!LooperUtil.hasLooperTag(instrumentBE)) {
                return;
            }
            EMIPacketHandler.sendToServer(new DoesLooperExistPacket());
        }
        LooperOverlayInjector.screen = instrumentScreen;
        recordBtn = Button.m_253074_((Component)LooperOverlayInjector.appendRecordKeyHint(Component.m_237115_((String)"button.evenmoreinstruments.record")), LooperOverlayInjector::onRecordPress).m_252780_(120).m_252794_((instrumentScreen.f_96543_ - 120) / 2, 5).m_253136_();
        event.addListener((GuiEventListener)recordBtn);
    }

    public static void handleLooperRemoved() {
        LooperOverlayInjector.removeRecordButton();
        screen = null;
    }

    private static MutableComponent appendRecordKeyHint(MutableComponent component) {
        return component.m_130946_(" (").m_7220_(((KeyMapping)KeyMappings.RECORD.get()).getKey().m_84875_()).m_130946_(")");
    }

    @SubscribeEvent
    public static void onKeyboardPress(ScreenEvent.KeyPressed.Pre event) {
        if (((KeyMapping)KeyMappings.RECORD.get()).m_90832_(event.getKeyCode(), event.getScanCode()) && recordBtn != null) {
            recordBtn.m_7435_(Minecraft.m_91087_().m_91106_());
            recordBtn.m_5691_();
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        if (event.getScreen() != screen) {
            return;
        }
        isRecording = false;
        screen = null;
    }

    private static void onRecordPress(Button btn) {
        InteractionHand hand;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean isItem = InstrumentOpenProvider.isItem((Player)player);
        InteractionHand interactionHand = hand = isItem ? InstrumentOpenProvider.getHand((Player)Minecraft.m_91087_().f_91074_) : null;
        if (isRecording) {
            LooperOverlayInjector.removeRecordButton();
            screen = null;
        } else {
            btn.m_93666_((Component)LooperOverlayInjector.appendRecordKeyHint(Component.m_237115_((String)"button.evenmoreinstruments.stop")));
        }
        isRecording = !isRecording;
        EMIPacketHandler.sendToServer(new LooperRecordStatePacket(isRecording, hand));
    }

    public static void removeRecordButton() {
        if (screen == null) {
            return;
        }
        ((ScreenAccessor)screen).invokeRemoveWidget((GuiEventListener)recordBtn);
        recordBtn = null;
    }
}

