/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.simple;

import org.tukaani.xz.simple.SimpleFilter;

public final class X86
implements SimpleFilter {
    private static final boolean[] MASK_TO_ALLOWED_STATUS = new boolean[]{true, true, true, false, true, false, false, false};
    private static final int[] MASK_TO_BIT_NUMBER = new int[]{0, 1, 2, 2, 3, 3, 3, 3};
    private final boolean isEncoder;
    private int pos;
    private int prevMask = 0;

    private static boolean test86MSByte(byte b) {
        int n = b & 0xFF;
        return n == 0 || n == 255;
    }

    public X86(boolean bl, int i) {
        this.isEncoder = bl;
        this.pos = i + 5;
    }

    @Override
    public int code(byte[] bs, int i, int j) {
        int n;
        int n2 = i - 1;
        int n3 = i + j - 5;
        for (n = i; n <= n3; ++n) {
            if ((bs[n] & 0xFE) != 232) continue;
            if (((n2 = n - n2) & 0xFFFFFFFC) != 0) {
                this.prevMask = 0;
            } else {
                this.prevMask = this.prevMask << n2 - 1 & 7;
                if (this.prevMask != 0 && (!MASK_TO_ALLOWED_STATUS[this.prevMask] || X86.test86MSByte(bs[n + 4 - MASK_TO_BIT_NUMBER[this.prevMask]]))) {
                    n2 = n;
                    this.prevMask = this.prevMask << 1 | 1;
                    continue;
                }
            }
            n2 = n;
            if (X86.test86MSByte(bs[n + 4])) {
                int n4;
                int n5 = bs[n + 1] & 0xFF | (bs[n + 2] & 0xFF) << 8 | (bs[n + 3] & 0xFF) << 16 | (bs[n + 4] & 0xFF) << 24;
                while (true) {
                    int n6;
                    n4 = this.isEncoder ? n5 + (this.pos + n - i) : n5 - (this.pos + n - i);
                    if (this.prevMask == 0 || !X86.test86MSByte((byte)(n4 >>> 24 - (n6 = MASK_TO_BIT_NUMBER[this.prevMask] * 8)))) break;
                    n5 = n4 ^ (1 << 32 - n6) - 1;
                }
                bs[n + 1] = (byte)n4;
                bs[n + 2] = (byte)(n4 >>> 8);
                bs[n + 3] = (byte)(n4 >>> 16);
                bs[n + 4] = (byte)(~((n4 >>> 24 & 1) - 1));
                n += 4;
                continue;
            }
            this.prevMask = this.prevMask << 1 | 1;
        }
        this.prevMask = ((n2 = n - n2) & 0xFFFFFFFC) != 0 ? 0 : this.prevMask << n2 - 1;
        this.pos += (n -= i);
        return n;
    }
}

