/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.decorative_core.block.base;

import com.yablon.decorative_core.block.entity.AbstractStorageBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractStorageBlockBase<T extends AbstractStorageBlockEntity>
extends Block
implements EntityBlock {
    public static final IntegerProperty ITEM_COUNT = IntegerProperty.m_61631_((String)"item_count", (int)0, (int)256);
    private final String storedItemId;
    private final VoxelShape shape;

    public AbstractStorageBlockBase(BlockBehaviour.Properties properties, String storedItemId, VoxelShape shape) {
        super(properties);
        this.storedItemId = storedItemId;
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ITEM_COUNT, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ITEM_COUNT});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity;
        if (!level.f_46443_ && (entity = level.m_7702_(pos)) instanceof AbstractStorageBlockEntity) {
            int retrievedAmount;
            AbstractStorageBlockEntity storageEntity = (AbstractStorageBlockEntity)entity;
            ItemStack heldItem = player.m_21120_(hand);
            String heldItemId = ForgeRegistries.ITEMS.getKey((Object)heldItem.m_41720_()).toString();
            if (heldItemId.equals(this.storedItemId)) {
                int storedCount = storageEntity.getItemCount();
                if (storedCount < 256) {
                    int insertAmount = Math.min(heldItem.m_41613_(), 256 - storedCount);
                    storageEntity.setItemCount(storedCount + insertAmount);
                    heldItem.m_41774_(insertAmount);
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ITEM_COUNT, (Comparable)Integer.valueOf(storageEntity.getItemCount())), 3);
                    storageEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Component.m_237115_((String)"gui.decorative_core.full_message"), true);
            } else if (player.m_6144_() && (retrievedAmount = Math.min(64, storageEntity.getItemCount())) > 0) {
                player.m_36356_(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(storageEntity.getStoredItem()), retrievedAmount));
                storageEntity.setItemCount(storageEntity.getItemCount() - retrievedAmount);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ITEM_COUNT, (Comparable)Integer.valueOf(storageEntity.getItemCount())), 3);
                storageEntity.m_6596_();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof AbstractStorageBlockEntity) {
                AbstractStorageBlockEntity storageEntity = (AbstractStorageBlockEntity)entity;
                storageEntity.dropAllStoredItems();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public String getStoredItemId() {
        return this.storedItemId;
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        ItemStack tool = player.m_21205_();
        if (tool.m_204117_(ItemTags.f_271207_)) {
            return 0.3f;
        }
        return 0.05f;
    }
}

