/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core;

import lilypuree.decorative_blocks.CommonAPI;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.fluid.ThatchBlock;
import lilypuree.decorative_blocks.mixin.ItemAccessor;
import lilypuree.decorative_blocks.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class Callbacks {
    public static boolean onLeftClick(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof BonfireBlock) {
            level.m_5898_(null, 1009, pos, 0);
            level.m_7471_(pos, false);
            return true;
        }
        return false;
    }

    public static InteractionResultHolder<ItemStack> onUseItem(Level level, Player player, ItemStack item) {
        if (item.m_204117_(ItemTags.f_271298_)) {
            return Callbacks.pickupThatch(level, player, item);
        }
        return InteractionResultHolder.m_19098_((Object)item);
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, ItemStack item, BlockHitResult hitResult) {
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (item.m_204117_(Services.PLATFORM.getShearTag()) && CommonAPI.shearMap.containsKey(block)) {
            return Callbacks.shearThatch(player, level, item, pos, block);
        }
        if (item.m_204117_(ItemTags.f_271207_) && block instanceof SupportBlock) {
            SupportBlock.onSupportActivation(state, level, pos, player, hitResult.m_82450_());
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult shearThatch(Player player, Level level, ItemStack itemStack, BlockPos pos, Block block) {
        if (!level.m_46469_().m_46207_(CommonAPI.RULE_DISABLE_THATCH)) {
            level.m_46597_(pos, CommonAPI.shearMap.get(block).getLiquidBlock().m_49966_());
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_5496_(SoundEvents.f_11838_, 1.2f, 1.0f);
            itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResultHolder<ItemStack> pickupThatch(Level level, Player player, ItemStack item) {
        BlockHitResult blockHitResult = ItemAccessor.getPlayerPOVHitResult(level, player, ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockState hitBlock;
            BlockPos hit = blockHitResult.m_82425_();
            Direction dir = blockHitResult.m_82434_();
            BlockPos thatchPos = hit.m_121945_(dir);
            if (level.m_7966_(player, hit) && player.m_36204_(thatchPos, dir, item) && (hitBlock = level.m_8055_(hit)).m_60734_() instanceof ThatchBlock && (Integer)hitBlock.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                player.m_5496_(SoundEvents.f_11838_, 1.2f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157794_, hit);
                level.m_7731_(hit, Blocks.f_50016_.m_49966_(), 11);
                return InteractionResultHolder.m_19092_((Object)item, (boolean)level.f_46443_);
            }
        }
        return InteractionResultHolder.m_19098_((Object)item);
    }
}

