/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.mixin_logic.client;

import com.simibubi.create.content.trains.track.TrackBlockOutline;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.create_interactive.mixin.TrackBlockOutlineAccessor;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public final class MixinTrackBlockOutlineLogic {
    @NotNull
    public static final MixinTrackBlockOutlineLogic INSTANCE = new MixinTrackBlockOutlineLogic();

    private MixinTrackBlockOutlineLogic() {
    }

    public final void postClientTick() {
        TrackBlockOutline.BezierPointSelection bezierPointSelection = TrackBlockOutlineAccessor.getResult();
        if (bezierPointSelection == null) {
            return;
        }
        TrackBlockOutline.BezierPointSelection origResult = bezierPointSelection;
        Level level = origResult.blockEntity().m_58904_();
        BlockPos blockPos = origResult.blockEntity().m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)blockPos);
        ClientShip clientShip = ship instanceof ClientShip ? (ClientShip)ship : null;
        if (clientShip == null) {
            return;
        }
        ClientShip clientShip2 = clientShip;
        Vec3 vec3 = origResult.direction();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"direction(...)");
        Vector3d vector3d = VectorConversionsMCKt.toJOML((Vec3)vec3).rotate(clientShip2.getRenderTransform().getShipToWorldRotation());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"rotate(...)");
        Vec3 newDirection = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
        TrackBlockOutlineAccessor.setResult(new TrackBlockOutline.BezierPointSelection(origResult.blockEntity(), origResult.loc(), origResult.vec(), origResult.angles(), newDirection));
    }
}

