/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.mixin_logic;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.create_interactive.CreateInteractiveUtil;
import org.valkyrienskies.create_interactive.GameContent;
import org.valkyrienskies.create_interactive.mixin.TrainAccessor;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;

public final class MixinTrainLogic {
    @NotNull
    public static final MixinTrainLogic INSTANCE = new MixinTrainLogic();

    private MixinTrainLogic() {
    }

    public final void preCanDisassemble$create_interactive(@NotNull Train train, @NotNull CallbackInfoReturnable<Boolean> cir) {
        Intrinsics.checkNotNullParameter((Object)train, (String)"train");
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        for (Carriage carriage : train.carriages) {
            CarriageContraptionEntity entity;
            if (carriage.anyAvailableEntity() == null) {
                return;
            }
            Map map = entity.getContraption().getBlocks();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBlocks(...)");
            if (!(!map.isEmpty())) continue;
            return;
        }
        cir.setReturnValue((Object)true);
    }

    public final void splitOrDisassemble$create_interactive(@NotNull Train train) {
        Intrinsics.checkNotNullParameter((Object)train, (String)"train");
        List carriages = train.carriages;
        List carriageSpacing = train.carriageSpacing;
        int n = carriages.size();
        for (int i = 0; i < n; ++i) {
            CarriageContraptionEntity entity;
            Object e = carriages.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            Carriage carriage = (Carriage)e;
            if (carriage.anyAvailableEntity() == null) {
                return;
            }
            if (!entity.getContraption().getBlocks().isEmpty()) continue;
            if (carriages.size() == 1) {
                BlockPos pos = BlockPos.m_274446_((Position)((Position)entity.m_20182_()));
                train.disassemble(Direction.NORTH, pos);
            } else if (i == 0) {
                Object e2 = carriages.remove(0);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"removeAt(...)");
                Carriage firstCar = (Carriage)e2;
                carriageSpacing.remove(0);
                firstCar.setTrain(null);
                entity.m_6074_();
            } else if (i == carriages.size() - 1) {
                Object e3 = carriages.remove(carriages.size() - 1);
                Intrinsics.checkNotNullExpressionValue(e3, (String)"removeAt(...)");
                Carriage lastCar = (Carriage)e3;
                carriageSpacing.remove(carriageSpacing.size() - 1);
                lastCar.setTrain(null);
                entity.m_6074_();
            }
            return;
        }
    }

    @NotNull
    public final Vector3i getLocationVec3i$create_interactive(@NotNull TrackNodeLocation $this$getLocationVec3i) {
        Intrinsics.checkNotNullParameter((Object)$this$getLocationVec3i, (String)"<this>");
        return new Vector3i($this$getLocationVec3i.m_123341_(), $this$getLocationVec3i.m_123342_(), $this$getLocationVec3i.m_123343_());
    }

    private final boolean collidingWithBufferStop(Train $this$collidingWithBufferStop) {
        BlockState level;
        BlockState blockState;
        BlockState blockState2;
        Vector3d vector3d;
        Carriage carriage;
        boolean isTrainMovingForward;
        boolean bl = isTrainMovingForward = $this$collidingWithBufferStop.targetSpeed >= 0.0;
        if (isTrainMovingForward) {
            List list = $this$collidingWithBufferStop.carriages;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"carriages");
            carriage = (Carriage)CollectionsKt.first((List)list);
        } else {
            List list = $this$collidingWithBufferStop.carriages;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"carriages");
            carriage = (Carriage)CollectionsKt.last((List)list);
        }
        Carriage leadingCar = carriage;
        TravellingPoint leading = leadingCar.getLeadingPoint();
        TravellingPoint trailing = leadingCar.getTrailingPoint();
        if (leading.edge == null || trailing.edge == null) {
            return false;
        }
        TravellingPoint bufferPoint = isTrainMovingForward ? leading : trailing;
        Vec3 position = bufferPoint.getPosition($this$collidingWithBufferStop.graph);
        BlockPos bufferStopPos = BlockPos.m_274446_((Position)((Position)position)).m_7918_(0, -1, 0);
        TrackNodeLocation trackNodeLocation = bufferPoint.node1.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)trackNodeLocation, (String)"getLocation(...)");
        Vector3ic node1Location = (Vector3ic)this.getLocationVec3i$create_interactive(trackNodeLocation);
        TrackNodeLocation trackNodeLocation2 = bufferPoint.node2.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)trackNodeLocation2, (String)"getLocation(...)");
        Vector3ic node2Location = (Vector3ic)this.getLocationVec3i$create_interactive(trackNodeLocation2);
        Vector3d $this$collidingWithBufferStop_u24lambda_u240 = vector3d = new Vector3d((Vector3ic)node1Location.sub(node2Location, new Vector3i())).normalize();
        boolean bl2 = false;
        if (!isTrainMovingForward) {
            $this$collidingWithBufferStop_u24lambda_u240.mul(-1.0);
        }
        Vector3d vector3d2 = vector3d;
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"apply(...)");
        Vector3dc normal = (Vector3dc)vector3d2;
        if (normal.x() > 0.0 || normal.z() > 0.0) {
            bufferStopPos = bufferStopPos.m_7918_(-MathKt.roundToInt((double)normal.x()), -MathKt.roundToInt((double)normal.y()), -MathKt.roundToInt((double)normal.z()));
        }
        ResourceKey dimension = bufferPoint.node1.getLocation().dimension;
        Object object = ValkyrienSkiesMod.getCurrentServer();
        if (object != null && (object = object.m_129785_()) != null) {
            Object element$iv;
            block8: {
                Object $this$first$iv = object;
                boolean $i$f$first = false;
                Iterator iterator = $this$first$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    ServerLevel it = (ServerLevel)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.m_46472_(), (Object)dimension)) continue;
                    break block8;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            blockState2 = (ServerLevel)element$iv;
        } else {
            blockState2 = null;
        }
        return Intrinsics.areEqual((Object)((blockState = (level = blockState2)) != null && (blockState = blockState.m_8055_(bufferStopPos)) != null ? blockState.m_60734_() : null), (Object)GameContent.INSTANCE.getBUFFER_STOP_BLOCK().get());
    }

    public final void tickOnEndOfTrack$create_interactive(@NotNull Train train) {
        Intrinsics.checkNotNullParameter((Object)train, (String)"train");
        if (!(train.targetSpeed == 0.0) && this.collidingWithBufferStop(train)) {
            return;
        }
        ((TrainAccessor)train).getMigratingPoints().clear();
        train.navigation.cancelNavigation();
        ((TrainAccessor)train).setGraph(null);
        ((TrainAccessor)train).setDerailed(true);
    }

    @Nullable
    public final Pair<Train, Vec3> findCollidingTrain(@NotNull Level level, @NotNull Vec3 start, @NotNull Vec3 end, @NotNull Train ignore, @NotNull ResourceKey<Level> dimension) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)ignore, (String)"ignore");
        Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
        for (Train train : Create.RAILWAYS.sided((LevelAccessor)((LevelAccessor)level)).trains.values()) {
            if (train == ignore || train.derailed) continue;
            Vec3 diff = end.m_82546_(start);
            Vec3 lastPoint = null;
            for (Carriage otherCarriage : train.carriages) {
                Intrinsics.checkNotNullExpressionValue((Object)Iterate.trueAndFalse, (String)"trueAndFalse");
                for (boolean betweenBits : Iterate.trueAndFalse) {
                    Vec3 normedDiff2;
                    ResourceKey otherDimension;
                    if (betweenBits && lastPoint == null) continue;
                    TravellingPoint otherLeading = otherCarriage.getLeadingPoint();
                    TravellingPoint otherTrailing = otherCarriage.getTrailingPoint();
                    if (otherLeading.edge == null || otherTrailing.edge == null || !Intrinsics.areEqual((Object)(otherDimension = otherLeading.node1.getLocation().dimension), (Object)otherTrailing.node1.getLocation().dimension) || !Intrinsics.areEqual((Object)otherDimension, dimension)) continue;
                    Vec3 start2 = otherLeading.getPosition(train.graph);
                    Vec3 end2 = otherTrailing.getPosition(train.graph);
                    if (betweenBits) {
                        end2 = start2;
                        start2 = lastPoint;
                    }
                    lastPoint = end2;
                    double d = end.f_82480_;
                    Vec3 vec3 = end2;
                    Intrinsics.checkNotNull((Object)vec3);
                    if (d < vec3.f_82480_ - (double)3 || end2.f_82480_ < end.f_82480_ - (double)3) {
                        double d2 = start.f_82480_;
                        Vec3 vec32 = start2;
                        Intrinsics.checkNotNull((Object)vec32);
                        if (d2 < vec32.f_82480_ - (double)3 || start2.f_82480_ < start.f_82480_ - (double)3) continue;
                    }
                    Vec3 diff2 = end2.m_82546_(start2);
                    Vec3 normedDiff = diff.m_82541_();
                    double[] intersect = VecHelper.intersect((Vec3)start, (Vec3)start2, (Vec3)normedDiff, (Vec3)(normedDiff2 = diff2.m_82541_()), (Direction.Axis)Direction.Axis.Y);
                    if (intersect == null) {
                        Vec3 intersectSphere;
                        if (VecHelper.intersectSphere((Vec3)start2, (Vec3)normedDiff2, (Vec3)start, (double)0.125) == null || !Mth.m_14082_((double)normedDiff2.m_82526_(intersectSphere.m_82546_(start2).m_82541_()), (double)1.0)) continue;
                        intersect = new double[]{intersectSphere.m_82554_(start) - 0.125, intersectSphere.m_82554_(start2) - 0.125};
                    }
                    if (intersect[0] > diff.m_82553_() || intersect[1] > diff2.m_82553_() || intersect[0] < 0.0 || intersect[1] < 0.0) continue;
                    return Pair.of((Object)train, (Object)start.m_82549_(normedDiff.m_82490_(intersect[0])));
                }
            }
        }
        return null;
    }

    public final void postTick$create_interactive(@NotNull Level level, @NotNull Train train) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)train, (String)"train");
        if (!train.derailed) {
            return;
        }
        List list = train.carriages;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"carriages");
        Carriage carriage = (Carriage)CollectionsKt.firstOrNull((List)list);
        if (carriage == null) {
            return;
        }
        Carriage firstCarriage = carriage;
        Carriage.DimensionalCarriageEntity dimensionalCarriageEntity = firstCarriage.getDimensional(level);
        if (dimensionalCarriageEntity == null) {
            return;
        }
        Carriage.DimensionalCarriageEntity carriageDimensionalEntity = dimensionalCarriageEntity;
        CarriageContraptionEntity carriageContraptionEntity = (CarriageContraptionEntity)carriageDimensionalEntity.entity.get();
        if (carriageContraptionEntity == null) {
            return;
        }
        CarriageContraptionEntity carriageEntity = carriageContraptionEntity;
        Contraption contraption = carriageEntity.getContraption();
        Intrinsics.checkNotNullExpressionValue((Object)contraption, (String)"getContraption(...)");
        Ship ship = CreateInteractiveUtil.INSTANCE.getShipForContraption$create_interactive(contraption);
        if (ship == null) {
            return;
        }
        Ship carriageShip = ship;
        Vector3d vector3d = carriageShip.getTransform().getShipToWorld().transformPosition(new Vector3d(CreateInteractiveUtil.INSTANCE.getChunkClaimCenterPos(carriageShip, level)).sub(0.0, 1.0, 0.0).add(0.5, 0.5, 0.5));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        Vector3dc leadingBogeyPosInWorld = (Vector3dc)vector3d;
        double searchRadius = 1.0;
        AABBdc searchBoxInWorld = (AABBdc)new AABBd((Vector3dc)new Vector3d(leadingBogeyPosInWorld).sub(searchRadius, searchRadius, searchRadius), (Vector3dc)new Vector3d(leadingBogeyPosInWorld).add(searchRadius, searchRadius, searchRadius));
        List shipsCollidingAndNull = CollectionsKt.plus((Iterable)VSGameUtilsKt.getShipsIntersecting((Level)level, (AABBdc)searchBoxInWorld), null);
        double closestDistSq = 0.0;
        closestDistSq = Double.POSITIVE_INFINITY;
        BlockPos closestTrackPos = null;
        Iterable $this$forEach$iv = shipsCollidingAndNull;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            int n;
            Ship ship2 = (Ship)element$iv;
            boolean bl = false;
            Ship ship3 = ship2;
            Vector3dc leadingBogeyPosRelative = ship3 != null ? (Vector3dc)ship3.getTransform().getWorldToShip().transformPosition(leadingBogeyPosInWorld, new Vector3d()) : leadingBogeyPosInWorld;
            AABBdc searchBox = (AABBdc)new AABBd((Vector3dc)new Vector3d(leadingBogeyPosRelative).sub(searchRadius, searchRadius, searchRadius), (Vector3dc)new Vector3d(leadingBogeyPosRelative).add(searchRadius, searchRadius, searchRadius));
            int x = (int)Math.floor(searchBox.minX());
            if (x > (n = (int)Math.ceil(searchBox.maxX()))) continue;
            while (true) {
                int n2;
                int y;
                if ((y = (int)Math.floor(searchBox.minY())) <= (n2 = (int)Math.ceil(searchBox.maxY()))) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = (int)Math.floor(searchBox.minZ())) <= (n3 = (int)Math.ceil(searchBox.maxZ()))) {
                            while (true) {
                                BlockPos blockPos;
                                BlockState blockState;
                                if ((blockState = level.m_8055_(blockPos = new BlockPos(x, y, z))).m_60734_() instanceof ITrackBlock) {
                                    Vector3dc vector3dc;
                                    Ship ship4 = ship2;
                                    if (ship4 != null) {
                                        Vector3d vector3d2 = ship4.getTransform().getShipToWorld().transformPosition(new Vector3d((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5));
                                        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transformPosition(...)");
                                        vector3dc = (Vector3dc)vector3d2;
                                    } else {
                                        vector3dc = (Vector3dc)new Vector3d((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                                    }
                                    Vector3dc trackPosInWorld = vector3dc;
                                    double distSq = leadingBogeyPosInWorld.distanceSquared(trackPosInWorld);
                                    if (distSq < closestDistSq) {
                                        closestDistSq = distSq;
                                        closestTrackPos = blockPos;
                                    }
                                }
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) continue block0;
                ++x;
            }
        }
        if (closestTrackPos == null) {
            return;
        }
        TrainRelocator.relocate((Train)train, (Level)level, closestTrackPos, null, (boolean)false, (Vec3)new Vec3(1.0, 0.0, 0.0), (boolean)false);
    }
}

