/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.mixin.deployer;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.create_interactive.mixin_logic.deployer.MixinDeployerRendererLogic;

@Mixin(value={DeployerInstance.class})
public abstract class MixinDeployerInstance
extends ShaftInstance<DeployerBlockEntity> {
    @Shadow(remap=false)
    float progress;
    @Shadow
    @Final
    Direction facing;
    @Shadow(remap=false)
    @Final
    protected OrientedData pole;
    @Shadow(remap=false)
    protected OrientedData hand;

    public MixinDeployerInstance(MaterialManager materialManager, DeployerBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    @Inject(method={"beginFrame"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preBeginFrame(CallbackInfo ci) {
        Double actorDistance = MixinDeployerRendererLogic.INSTANCE.preGetHandOffset$create_interactive((DeployerBlockEntity)this.blockEntity);
        if (actorDistance == null) {
            return;
        }
        this.progress = actorDistance.floatValue();
        BlockPos blockPos = this.getInstancePosition();
        Vec3i facingVec = this.facing.m_122436_();
        float x = (float)blockPos.m_123341_() + (float)facingVec.m_123341_() * actorDistance.floatValue();
        float y = (float)blockPos.m_123342_() + (float)facingVec.m_123342_() * actorDistance.floatValue();
        float z = (float)blockPos.m_123343_() + (float)facingVec.m_123343_() * actorDistance.floatValue();
        this.pole.setPosition(x, y, z);
        this.hand.setPosition(x, y, z);
        ci.cancel();
    }
}

