/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.forge.mixin;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.create_interactive.forge.mixin_logic.mixin.MixinMountedStorageManagerLogic;
import org.valkyrienskies.create_interactive.mixinducks.AbstractContraptionEntityDuck;

@Mixin(value={MountedStorageManager.class})
public abstract class MixinMountedStorageManager {
    @Unique
    private Long ci$shipId = null;
    @Unique
    private List<IItemHandlerModifiable> ci$externalStorages;
    @Shadow(remap=false)
    protected Contraption.ContraptionInvWrapper inventory;
    @Shadow(remap=false)
    protected Contraption.ContraptionInvWrapper fuelInventory;
    @Shadow(remap=false)
    protected CombinedTankWrapper fluidInventory;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(CallbackInfo ci) {
        this.ci$externalStorages = new ArrayList<IItemHandlerModifiable>();
    }

    @Inject(method={"entityTick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preEntityTick(AbstractContraptionEntity entity, CallbackInfo ci) {
        this.ci$shipId = ((AbstractContraptionEntityDuck)entity).ci$getShadowShipId();
        if (this.check()) {
            ci.cancel();
            if (entity.m_9236_().f_46443_) {
                return;
            }
            if (this.inventory == null) {
                this.inventory = new Contraption.ContraptionInvWrapper(new IItemHandlerModifiable[0]);
            }
            if (this.fuelInventory == null) {
                this.fuelInventory = new Contraption.ContraptionInvWrapper(new IItemHandlerModifiable[0]);
            }
            if (this.fluidInventory == null) {
                this.fluidInventory = new CombinedTankWrapper(new IFluidHandler[0]);
            }
            MixinMountedStorageManagerLogic.INSTANCE.preEntityTick$create_interactive(entity, this.ci$shipId, this.ci$externalStorages, this.inventory, this.fuelInventory, this.fluidInventory);
        }
    }

    @Inject(method={"createHandlers"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preCreateHandlers(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
            this.inventory = new Contraption.ContraptionInvWrapper(new IItemHandlerModifiable[0]);
            this.fuelInventory = new Contraption.ContraptionInvWrapper(new IItemHandlerModifiable[0]);
            this.fluidInventory = new CombinedTankWrapper(new IFluidHandler[0]);
        }
    }

    @Inject(method={"addBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preAddBlock(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"read"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preRead(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"bindTanks"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preBindTanks(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"write"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preWrite(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"removeStorageFromWorld"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preRemoveStorageFromWorld(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"addStorageToWorld"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preAddStorageToWorld(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"clear"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preClear(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"updateContainedFluid"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preUpdateContainedFluid(CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
        }
    }

    @Inject(method={"attachExternal"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preAttachExternal(IItemHandlerModifiable externalStorage, CallbackInfo ci) {
        if (this.check()) {
            ci.cancel();
            if (externalStorage == null) {
                return;
            }
            this.ci$externalStorages.add(externalStorage);
        }
    }

    @Inject(method={"handlePlayerStorageInteraction"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preHandlePlayerStorageInteraction(Contraption contraption, Player player, BlockPos localPos, CallbackInfoReturnable<Boolean> cir) {
        if (this.check()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean check() {
        return this.ci$shipId != null;
    }
}

