/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive.content;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.create_interactive.CreateInteractiveUtil;
import org.valkyrienskies.create_interactive.GameContent;
import org.valkyrienskies.create_interactive.MinecraftUtilsKt;
import org.valkyrienskies.create_interactive.content.propagating_axis.PropagatingAxisBlock;
import org.valkyrienskies.create_interactive.mixinducks.AbstractContraptionEntityDuck;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public final class PropagatingTools {
    @NotNull
    public static final PropagatingTools INSTANCE = new PropagatingTools();

    private PropagatingTools() {
    }

    @Nullable
    public final AbstractContraptionEntity getContraptionOfPropagateBase(@NotNull BlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        BlockEntity blockEntity = be;
        return blockEntity instanceof MechanicalBearingBlockEntity ? (AbstractContraptionEntity)((MechanicalBearingBlockEntity)be).getMovedContraption() : (blockEntity instanceof LinearActuatorBlockEntity ? ((LinearActuatorBlockEntity)be).movedContraption : null);
    }

    public final boolean isPropagateBase(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return blockState.m_60734_() instanceof BearingBlock || blockState.m_60734_() instanceof PistonBaseBlock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkIfConnected(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (direction == null) {
            Direction it;
            Comparable comparable = state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            Iterable $this$any$iv = MinecraftUtilsKt.getDirections((Direction.Axis)comparable);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (Direction)element$iv;
                boolean bl = false;
            } while (!INSTANCE.checkIfConnected(level, state, pos, it));
            return true;
        }
        BlockState blockState = level.m_8055_(pos.m_121945_(direction));
        Intrinsics.checkNotNull((Object)blockState);
        if (this.isConnectedPropagator(blockState) && blockState.m_61143_((Property)RotatedPillarKineticBlock.AXIS) == state.m_61143_((Property)RotatedPillarKineticBlock.AXIS)) {
            return true;
        }
        boolean bl = false;
        boolean isPropagating = bl;
        if (isPropagating) return true;
        if (this.isPropagateBase(blockState)) return true;
        BlockPos blockPos = pos.m_121945_(direction);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        if (!this.isContraptionBase(level, blockPos)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConnectedPropagator(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (!(blockState.m_60734_() instanceof PropagatingAxisBlock)) return false;
        Comparable comparable = blockState.m_61143_((Property)GameContent.INSTANCE.getCONNECTED());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        if ((Boolean)comparable == false) return false;
        return true;
    }

    public final boolean isContraptionBase(@NotNull Level level, @NotNull BlockPos location) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)location);
        return Intrinsics.areEqual((Object)(ship != null ? CreateInteractiveUtil.INSTANCE.getChunkClaimCenterPos(ship, level) : null), (Object)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)location)).sub(0, 1, 0));
    }

    @NotNull
    public final List<Pair<BlockPos, BlockPos>> getPropagators(@NotNull Contraption contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        AbstractContraptionEntity abstractContraptionEntity = contraption.entity;
        Intrinsics.checkNotNull((Object)abstractContraptionEntity, (String)"null cannot be cast to non-null type org.valkyrienskies.create_interactive.mixinducks.AbstractContraptionEntityDuck");
        List<Pair<BlockPos, BlockPos>> list = ((AbstractContraptionEntityDuck)abstractContraptionEntity).ci$getPropagators();
        Intrinsics.checkNotNullExpressionValue(list, (String)"ci$getPropagators(...)");
        return list;
    }
}

