/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.create_interactive;

import java.time.Duration;
import java.time.Instant;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class RateLimiter {
    @NotNull
    private final Duration minTimeSincePrev;
    @NotNull
    private Instant lastCall;

    public RateLimiter(@NotNull Duration minTimeSincePrev) {
        Intrinsics.checkNotNullParameter((Object)minTimeSincePrev, (String)"minTimeSincePrev");
        this.minTimeSincePrev = minTimeSincePrev;
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.lastCall = instant;
    }

    public final void maybeRun(@NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Instant now = Instant.now();
        if (Duration.between(this.lastCall, now).compareTo(this.minTimeSincePrev) > 0) {
            block.run();
            Intrinsics.checkNotNull((Object)now);
            this.lastCall = now;
        }
    }
}

