/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.network;

import com.ibarnstormer.gbd.capability.ModCapabilityProvider;
import com.ibarnstormer.gbd.network.IModPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdatePlayerCapabilitiesPacket
implements IModPacket {
    boolean active;
    boolean canToggle;

    public UpdatePlayerCapabilitiesPacket(boolean active, boolean canToggle) {
        this.active = active;
        this.canToggle = canToggle;
    }

    public UpdatePlayerCapabilitiesPacket(FriendlyByteBuf buf) {
        this.active = buf.readBoolean();
        this.canToggle = buf.readBoolean();
    }

    @Override
    public void send(FriendlyByteBuf buf) {
        buf.writeBoolean(this.active);
        buf.writeBoolean(this.canToggle);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> {
                    cap.setActive(this.active);
                    cap.setToggleability(this.canToggle);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

