/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModLootModifiers {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"creategbd");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> APPEND_MODIFIER = LOOT_MODIFIERS.register("append_item", AppendItemModifier.CODEC);

    public static void register() {
        LOOT_MODIFIERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static class AppendItemModifier
    extends LootModifier {
        private final ItemStack appendedStack;
        public static final Supplier<Codec<AppendItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(i -> AppendItemModifier.codecStart((RecordCodecBuilder.Instance)i).and((App)ItemStack.f_41582_.fieldOf("item").forGetter(m -> m.appendedStack)).apply((Applicative)i, AppendItemModifier::new)));

        protected AppendItemModifier(LootItemCondition[] conditionsIn, ItemStack stack) {
            super(conditionsIn);
            this.appendedStack = stack;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ItemStack stack = this.appendedStack.m_41777_();
            if (stack.m_41613_() <= 0) {
                stack.m_41764_(1);
            }
            generatedLoot.add((Object)stack);
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

