/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.compat.curios.CBCCuriosRenderers;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.forge.CBCModsForge;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;
import rbasamoyai.createbigcannons.index.CBCRenderTypes;

public class CBCClientForge {
    public static void prepareClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        CBCBlockPartials.init();
        modEventBus.addListener(CBCClientForge::onClientSetup);
        modEventBus.addListener(CBCClientForge::onRegisterKeyMappings);
        modEventBus.addListener(CBCClientForge::onRegisterParticleFactories);
        modEventBus.addListener(CBCClientForge::onLoadComplete);
        modEventBus.addListener(CBCClientForge::onRegisterClientReloadListeners);
        modEventBus.addListener(CBCClientForge::onRegisterGuiOverlays);
        modEventBus.addListener(CBCClientForge::onRegisterShaders);
        forgeEventBus.addListener(CBCClientForge::getFogColor);
        forgeEventBus.addListener(CBCClientForge::getFogDensity);
        forgeEventBus.addListener(CBCClientForge::onClientGameTick);
        forgeEventBus.addListener(CBCClientForge::onScrollMouse);
        forgeEventBus.addListener(CBCClientForge::onFovModify);
        forgeEventBus.addListener(CBCClientForge::onPlayerRenderPre);
        forgeEventBus.addListener(CBCClientForge::onSetupCamera);
        forgeEventBus.addListener(CBCClientForge::onPlayerLogOut);
        forgeEventBus.addListener(CBCClientForge::onClickMouse);
        forgeEventBus.addListener(CBCClientForge::onLoadClientLevel);
        forgeEventBus.addListener(CBCClientForge::onPlayerLogIn);
        forgeEventBus.addListener(CBCClientForge::onPlayerChangeDimension);
        CBCModsForge.CURIOS.executeIfInstalled(() -> () -> CBCCuriosRenderers.register(modEventBus, forgeEventBus));
    }

    private static void wrapOverlay(String id, CBCClientCommon.CBCGuiOverlay overlay, VanillaGuiOverlay renderOver, RegisterGuiOverlaysEvent event) {
        event.registerAbove(renderOver.id(), id, (gui, stack, partialTicks, width, height) -> overlay.renderOverlay(stack, partialTicks, width, height));
    }

    public static void onRegisterParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        CBCClientCommon.onRegisterParticleFactories(mc, mc.f_91061_);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        CBCClientCommon.onClientSetup();
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        CBCClientCommon.registerKeyMappings(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    public static void getFogColor(ViewportEvent.ComputeFogColor event) {
        CBCClientCommon.setFogColor(event.getCamera(), (r, g, b) -> {
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
        });
    }

    public static void getFogDensity(ViewportEvent.RenderFog event) {
        if (!event.isCancelable()) {
            return;
        }
        float density = CBCClientCommon.getFogDensity(event.getCamera(), event.getFarPlaneDistance());
        if (density != -1.0f) {
            event.setFarPlaneDistance(density);
            event.setNearPlaneDistance(density);
            event.setCanceled(true);
        }
    }

    public static void onClientGameTick(TickEvent.ClientTickEvent evt) {
        CBCClientCommon.onClientGameTick(Minecraft.m_91087_());
    }

    public static void onClickMouse(InputEvent.InteractionKeyMappingTriggered evt) {
        if (CBCClientCommon.onClickMouse(evt.getKeyMapping()) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onScrollMouse(InputEvent.MouseScrollingEvent evt) {
        if (CBCClientCommon.onScrollMouse(Minecraft.m_91087_(), evt.getScrollDelta()) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onFovModify(ComputeFovModifierEvent evt) {
        evt.setNewFovModifier(CBCClientCommon.onFovModify(Minecraft.m_91087_(), evt.getNewFovModifier()));
    }

    public static void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        CBCClientCommon.onPlayerRenderPre(evt.getPoseStack(), (LivingEntity)evt.getEntity(), evt.getPartialTick());
    }

    public static void onSetupCamera(ViewportEvent.ComputeCameraAngles evt) {
        if (CBCClientCommon.onCameraSetup(evt.getCamera(), evt.getPartialTick(), () -> ((ViewportEvent.ComputeCameraAngles)evt).getYaw(), () -> ((ViewportEvent.ComputeCameraAngles)evt).getPitch(), () -> ((ViewportEvent.ComputeCameraAngles)evt).getRoll(), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setYaw(arg_0), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setPitch(arg_0), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setRoll(arg_0)) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onLoadClientLevel(LevelEvent.Load evt) {
        LevelAccessor level = evt.getLevel();
        if (!level.m_5776_()) {
            return;
        }
        CBCClientCommon.onLoadClientLevel(level);
    }

    public static void onPlayerLogOut(ClientPlayerNetworkEvent.LoggingOut evt) {
        CBCClientCommon.onPlayerLogOut(evt.getPlayer());
    }

    public static void onPlayerLogIn(ClientPlayerNetworkEvent.LoggingIn evt) {
        CBCClientCommon.onPlayerLogIn(evt.getPlayer());
    }

    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent evt) {
        CBCClientCommon.onChangeDimension(evt.getEntity());
    }

    public static void onLoadComplete(FMLLoadCompleteEvent evt) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById("createbigcannons").orElseThrow(() -> new IllegalStateException("CBC mod container missing on LoadComplete"));
        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> CBCConfigs.createConfigScreen(screen)));
    }

    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent evt) {
        CBCClientCommon.registerClientReloadListeners((listener, id) -> evt.registerReloadListener(listener));
    }

    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent evt) {
        CBCClientCommon.registerOverlays("hotbar", (id, overlay) -> CBCClientForge.wrapOverlay(id, overlay, VanillaGuiOverlay.HOTBAR, evt));
        CBCClientCommon.registerOverlays("helmet", (id, overlay) -> CBCClientForge.wrapOverlay(id, overlay, VanillaGuiOverlay.HELMET, evt));
    }

    public static void onRegisterShaders(RegisterShadersEvent evt) {
        try {
            CBCRenderTypes.registerAllShaders((arg_0, arg_1) -> ((RegisterShadersEvent)evt).registerShader(arg_0, arg_1), ShaderInstance::new, evt.getResourceProvider());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to reload Create Big Cannons shaders: ", e);
        }
    }
}

