/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.fixed_cannon_mount;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.ExtendsCannonMount;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_control.fixed_cannon_mount.FixedCannonMountBlock;
import rbasamoyai.createbigcannons.cannons.CannonContraptionProviderBlock;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class FixedCannonMountBlockEntity
extends SmartBlockEntity
implements IDisplayAssemblyExceptions,
ControlPitchContraption.Block,
IHaveGoggleInformation {
    private AssemblyException lastException = null;
    protected PitchOrientedContraptionEntity mountedContraption;
    private boolean running;
    private float cannonYaw;
    private float cannonPitch;
    private FixedCannonMountScrollValueBehaviour pitchSlot;
    private FixedCannonMountScrollValueBehaviour yawSlot;

    public FixedCannonMountBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (CBCBlocks.FIXED_CANNON_MOUNT.has(state)) {
            this.cannonYaw = ((Direction)state.m_61143_((Property)FixedCannonMountBlock.f_52588_)).m_122435_();
        }
        this.setLazyTickRate(3);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.pitchSlot = new FixedCannonMountScrollValueBehaviour(this, true);
        behaviours.add((BlockEntityBehaviour)this.pitchSlot);
        this.yawSlot = new FixedCannonMountScrollValueBehaviour(this, false);
        behaviours.add((BlockEntityBehaviour)this.yawSlot);
    }

    public void onRedstoneUpdate(boolean assemblyPowered, boolean prevAssemblyPowered, boolean firePowered, boolean prevFirePowered, int firePower) {
        Level level;
        if (assemblyPowered != prevAssemblyPowered) {
            this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FixedCannonMountBlock.ASSEMBLY_POWERED, (Comparable)Boolean.valueOf(assemblyPowered)), 3);
            if (assemblyPowered) {
                try {
                    this.assemble();
                    this.lastException = null;
                }
                catch (AssemblyException e) {
                    this.lastException = e;
                    this.sendData();
                }
            } else {
                this.disassemble();
                this.sendData();
            }
        }
        if (firePowered != prevFirePowered) {
            this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FixedCannonMountBlock.FIRE_POWERED, (Comparable)Boolean.valueOf(firePowered)), 3);
        }
        if (this.running && this.mountedContraption != null && (level = this.m_58904_()) instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).onRedstoneUpdate(slevel, this.mountedContraption, firePowered != prevFirePowered, firePower, this);
        }
    }

    public void tick() {
        super.tick();
        if (this.mountedContraption != null && !this.mountedContraption.m_6084_()) {
            this.mountedContraption = null;
        }
        this.applyRotation();
    }

    protected void applyRotation() {
        if (this.mountedContraption == null) {
            return;
        }
        Direction dir = this.mountedContraption.getInitialOrientation();
        boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
        float sgn = flag ? 1.0f : -1.0f;
        float pitchAdjust = this.pitchSlot == null ? 0.0f : (float)this.pitchSlot.getValue();
        this.mountedContraption.pitch = (this.cannonPitch + pitchAdjust) * sgn;
        float yawAdjust = this.yawSlot == null ? 0.0f : (float)this.yawSlot.getValue();
        this.mountedContraption.yaw = this.cannonYaw + yawAdjust;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.running && this.mountedContraption != null) {
            this.sendData();
        }
    }

    protected void assemble() throws AssemblyException {
        PitchOrientedContraptionEntity contraptionEntity;
        if (!CBCBlocks.FIXED_CANNON_MOUNT.has(this.m_58900_())) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos assemblyPos = this.f_58858_.m_121945_(facing);
        if (this.m_58904_().m_151570_(assemblyPos)) {
            throw CannonMountBlockEntity.cannonBlockOutsideOfWorld(assemblyPos);
        }
        AbstractMountedCannonContraption mountedCannon = this.getContraption(assemblyPos);
        if (mountedCannon == null || !mountedCannon.assemble(this.m_58904_(), assemblyPos)) {
            return;
        }
        Direction facing1 = mountedCannon.initialOrientation();
        this.running = true;
        mountedCannon.removeBlocksFromWorld(this.m_58904_(), BlockPos.f_121853_);
        this.mountedContraption = contraptionEntity = PitchOrientedContraptionEntity.create(this.m_58904_(), (Contraption)mountedCannon, facing1, this);
        this.resetContraptionToOffset();
        this.m_58904_().m_7967_((Entity)contraptionEntity);
        this.sendData();
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.m_58904_(), (Vec3i)this.f_58858_);
    }

    private AbstractMountedCannonContraption getContraption(BlockPos pos) {
        AbstractMountedCannonContraption abstractMountedCannonContraption;
        Block block = this.f_58857_.m_8055_(pos).m_60734_();
        if (block instanceof CannonContraptionProviderBlock) {
            CannonContraptionProviderBlock provBlock = (CannonContraptionProviderBlock)block;
            abstractMountedCannonContraption = provBlock.getCannonContraption();
        } else {
            abstractMountedCannonContraption = null;
        }
        return abstractMountedCannonContraption;
    }

    protected void resetContraptionToOffset() {
        if (this.mountedContraption == null) {
            return;
        }
        this.cannonPitch = 0.0f;
        this.cannonYaw = this.getContraptionDirection().m_122435_();
        this.mountedContraption.pitch = this.cannonPitch;
        this.mountedContraption.yaw = this.cannonYaw;
        this.mountedContraption.prevPitch = this.mountedContraption.pitch;
        this.mountedContraption.prevYaw = this.mountedContraption.yaw;
        this.mountedContraption.m_146926_(this.cannonPitch);
        this.mountedContraption.m_146922_(this.cannonYaw);
        this.mountedContraption.f_19860_ = this.mountedContraption.m_146909_();
        this.mountedContraption.f_19859_ = this.mountedContraption.m_146908_();
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        Vec3 vec = Vec3.m_82539_((Vec3i)this.f_58858_.m_121945_(facing));
        this.mountedContraption.m_146884_(vec);
    }

    public Direction getContraptionDirection() {
        return this.mountedContraption == null ? Direction.NORTH : ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).initialOrientation();
    }

    @Override
    public void disassemble() {
        if (!this.running && this.mountedContraption == null) {
            return;
        }
        if (this.mountedContraption != null) {
            this.resetContraptionToOffset();
            this.mountedContraption.m_20223_(new CompoundTag());
            this.mountedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.m_58904_(), (Vec3i)this.f_58858_);
        }
        this.running = false;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity entity) {
        return this.mountedContraption == entity;
    }

    @Override
    public void attach(PitchOrientedContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof AbstractMountedCannonContraption)) {
            return;
        }
        this.mountedContraption = contraption;
        if (!this.f_58857_.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    @Override
    public BlockPos getDismountPositionForContraption(PitchOrientedContraptionEntity poce) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        return this.f_58858_.m_121945_(this.mountedContraption.getInitialOrientation().m_122424_()).m_121945_(facing);
    }

    @Override
    public BlockState getControllerState() {
        return this.m_58900_();
    }

    @Override
    public BlockPos getControllerBlockPos() {
        return this.f_58858_;
    }

    public void remove() {
        this.f_58859_ = true;
        if (!this.f_58857_.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("Running", this.running);
        tag.m_128350_("CannonYaw", this.cannonYaw);
        tag.m_128350_("CannonPitch", this.cannonPitch);
        AssemblyException.write((CompoundTag)tag, (AssemblyException)this.lastException);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.running = tag.m_128471_("Running");
        this.cannonYaw = tag.m_128457_("CannonYaw");
        this.cannonPitch = tag.m_128457_("CannonPitch");
        this.lastException = AssemblyException.read((CompoundTag)tag);
        if (!clientPacket) {
            return;
        }
        if (!this.running) {
            this.mountedContraption = null;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ExtendsCannonMount.addCannonInfoToTooltip(tooltip, this.mountedContraption);
        return true;
    }

    public Vec3 getInteractionLocation() {
        Vec3 vec3;
        Contraption contraption;
        if (this.mountedContraption != null && (contraption = this.mountedContraption.getContraption()) instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            vec3 = cannon.getInteractionVec(this.mountedContraption);
        } else {
            vec3 = Vec3.m_82512_((Vec3i)this.f_58858_);
        }
        return vec3;
    }

    @Nullable
    public PitchOrientedContraptionEntity getContraption() {
        return this.mountedContraption;
    }

    public static class FixedCannonMountScrollValueBehaviour
    extends ValveHandleBlockEntity.ValveHandleScrollValueBehaviour {
        public static final BehaviourType<FixedCannonMountScrollValueBehaviour> PITCH_TYPE = new BehaviourType();
        public static final BehaviourType<FixedCannonMountScrollValueBehaviour> YAW_TYPE = new BehaviourType();
        private final boolean pitch;
        private final ValueBoxTransform newSlotPositioning;

        public FixedCannonMountScrollValueBehaviour(SmartBlockEntity be, boolean pitch) {
            super(be);
            String suffix = pitch ? "pitch" : "yaw";
            this.setLabel((Component)Lang.builder((String)"createbigcannons").translate("fixed_cannon_mount.angle_" + suffix, new Object[0]).component());
            this.newSlotPositioning = new FixedCannonMountValueBox(pitch);
            this.pitch = pitch;
            this.between(-45, 45);
            this.withFormatter(v -> String.format("%s%d", v < 0 ? "-" : (v > 0 ? "+" : ""), Math.abs(v)) + Lang.translateDirect((String)"generic.unit.degrees", (Object[])new Object[0]).getString());
        }

        public boolean testHit(Vec3 hit) {
            BlockState state = this.blockEntity.m_58900_();
            Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.blockEntity.m_58899_()));
            return this.newSlotPositioning.testHit(state, localHit);
        }

        public MutableComponent formatValue(ValueSettingsBehaviour.ValueSettings settings) {
            int sgn = settings.row() == 0 ? -1 : 1;
            return Lang.number((double)(settings.value() * sgn)).add(Lang.translateDirect((String)"generic.unit.degrees", (Object[])new Object[0])).component();
        }

        public void onShortInteract(Player player, InteractionHand hand, Direction side) {
        }

        public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
            int value = valueSetting.value();
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            this.setValue(valueSetting.row() == 0 ? -value : value);
        }

        public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
            ImmutableList rows = ImmutableList.of((Object)Components.literal((String)"-").m_130940_(ChatFormatting.BOLD), (Object)Components.literal((String)"+").m_130940_(ChatFormatting.BOLD));
            return new ValueSettingsBoard(this.label, 45, 15, (List)rows, new ValueSettingsFormatter(this::formatValue));
        }

        public ValueBoxTransform getSlotPositioning() {
            return this.newSlotPositioning;
        }

        public BehaviourType<?> getType() {
            return this.pitch ? PITCH_TYPE : YAW_TYPE;
        }

        public boolean setsPitch() {
            return this.pitch;
        }

        public void write(CompoundTag nbt, boolean clientPacket) {
            nbt.m_128405_(this.pitch ? "PitchAdjustment" : "YawAdjustment", this.value);
        }

        public void read(CompoundTag nbt, boolean clientPacket) {
            this.value = nbt.m_128451_(this.pitch ? "PitchAdjustment" : "YawAdjustment");
        }
    }

    public static class FixedCannonMountValueBox
    extends CenteredSideValueBoxTransform {
        private final boolean pitch;

        public FixedCannonMountValueBox(boolean pitch) {
            super((state, dir) -> state.m_61143_((Property)BlockStateProperties.f_61372_) != dir);
            this.pitch = pitch;
        }

        protected Vec3 getSouthLocation() {
            double xOffset = this.pitch ? -4.0 : 4.0;
            return VecHelper.voxelSpace((double)(8.0 + xOffset), (double)8.0, (double)15.5);
        }
    }
}

