/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.simibubi.create.Create;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CreateBlockEntityBuilder<T extends BlockEntity, P>
extends BlockEntityBuilder<T, P> {
    @Nullable
    private NonNullSupplier<BiFunction<MaterialManager, T, BlockEntityInstance<? super T>>> instanceFactory;
    private NonNullPredicate<T> renderNormally;
    private Collection<NonNullSupplier<? extends Collection<NonNullSupplier<? extends Block>>>> deferredValidBlocks = new ArrayList<NonNullSupplier<? extends Collection<NonNullSupplier<? extends Block>>>>();

    public static <T extends BlockEntity, P> BlockEntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return new CreateBlockEntityBuilder<T, P>(owner, parent, name, callback, factory);
    }

    protected CreateBlockEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        super(owner, parent, name, callback, factory);
    }

    public CreateBlockEntityBuilder<T, P> validBlocksDeferred(NonNullSupplier<? extends Collection<NonNullSupplier<? extends Block>>> blocks) {
        this.deferredValidBlocks.add(blocks);
        return this;
    }

    protected BlockEntityType<T> createEntry() {
        this.deferredValidBlocks.stream().map(Supplier::get).flatMap(Collection::stream).forEach(arg_0 -> ((CreateBlockEntityBuilder)this).validBlock(arg_0));
        return super.createEntry();
    }

    public CreateBlockEntityBuilder<T, P> instance(NonNullSupplier<BiFunction<MaterialManager, T, BlockEntityInstance<? super T>>> instanceFactory) {
        return this.instance(instanceFactory, true);
    }

    public CreateBlockEntityBuilder<T, P> instance(NonNullSupplier<BiFunction<MaterialManager, T, BlockEntityInstance<? super T>>> instanceFactory, boolean renderNormally) {
        return this.instance(instanceFactory, be -> renderNormally);
    }

    public CreateBlockEntityBuilder<T, P> instance(NonNullSupplier<BiFunction<MaterialManager, T, BlockEntityInstance<? super T>>> instanceFactory, NonNullPredicate<T> renderNormally) {
        if (this.instanceFactory == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerInstance);
        }
        this.instanceFactory = instanceFactory;
        this.renderNormally = renderNormally;
        return this;
    }

    protected void registerInstance() {
        OneTimeEventReceiver.addModListener((AbstractRegistrate)Create.REGISTRATE, FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<BiFunction<MaterialManager, T, BlockEntityInstance<? super T>>> instanceFactory = this.instanceFactory;
            if (instanceFactory != null) {
                NonNullPredicate renderNormally = this.renderNormally;
                InstancedRenderRegistry.configure((BlockEntityType)((BlockEntityType)this.getEntry())).factory((BiFunction)instanceFactory.get()).skipRender(be -> !renderNormally.test(be)).apply();
            }
        });
    }
}

