/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBogeyBlockEntity
extends CachedRenderBBBlockEntity {
    public static final String BOGEY_STYLE_KEY = "BogeyStyle";
    public static final String BOGEY_DATA_KEY = "BogeyData";
    private CompoundTag bogeyData;
    LerpedFloat virtualAnimation = LerpedFloat.angular();

    public AbstractBogeyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract BogeyStyle getDefaultStyle();

    public CompoundTag getBogeyData() {
        if (this.bogeyData == null || !this.bogeyData.m_128441_(BOGEY_STYLE_KEY)) {
            this.bogeyData = this.createBogeyData();
        }
        return this.bogeyData;
    }

    public void setBogeyData(@NotNull CompoundTag newData) {
        if (!newData.m_128441_(BOGEY_STYLE_KEY)) {
            ResourceLocation style = this.getDefaultStyle().name;
            NBTHelper.writeResourceLocation(newData, BOGEY_STYLE_KEY, style);
        }
        this.bogeyData = newData;
    }

    public void setBogeyStyle(@NotNull BogeyStyle style) {
        ResourceLocation location = style.name;
        CompoundTag data = this.getBogeyData();
        NBTHelper.writeResourceLocation(data, BOGEY_STYLE_KEY, location);
        this.markUpdated();
    }

    @NotNull
    public BogeyStyle getStyle() {
        CompoundTag data = this.getBogeyData();
        ResourceLocation currentStyle = NBTHelper.readResourceLocation(data, BOGEY_STYLE_KEY);
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(currentStyle);
        if (style == null) {
            this.setBogeyStyle(this.getDefaultStyle());
            return this.getStyle();
        }
        return style;
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        CompoundTag data = this.getBogeyData();
        if (data != null) {
            pTag.m_128365_(BOGEY_DATA_KEY, (Tag)data);
        }
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        this.bogeyData = pTag.m_128441_(BOGEY_DATA_KEY) ? pTag.m_128469_(BOGEY_DATA_KEY) : this.createBogeyData();
        super.m_142466_(pTag);
    }

    private CompoundTag createBogeyData() {
        CompoundTag nbt = new CompoundTag();
        NBTHelper.writeResourceLocation(nbt, BOGEY_STYLE_KEY, this.getDefaultStyle().name);
        boolean upsideDown = false;
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogeyBlock = (AbstractBogeyBlock)block;
            upsideDown = bogeyBlock.isUpsideDown(this.m_58900_());
        }
        nbt.m_128379_("UpsideDown", upsideDown);
        return nbt;
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public float getVirtualAngle(float partialTicks) {
        return this.virtualAnimation.getValue(partialTicks);
    }

    public void animate(float distanceMoved) {
        BlockState blockState = this.m_58900_();
        Block block = blockState.m_60734_();
        if (!(block instanceof AbstractBogeyBlock)) {
            return;
        }
        AbstractBogeyBlock type = (AbstractBogeyBlock)block;
        double angleDiff = (double)(360.0f * distanceMoved) / (Math.PI * 2 * type.getWheelRadius());
        double newWheelAngle = ((double)this.virtualAnimation.getValue() - angleDiff) % 360.0;
        this.virtualAnimation.setValue(newWheelAngle);
    }

    private void markUpdated() {
        this.m_6596_();
        Level level = this.m_58904_();
        if (level != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

