/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.item;

import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.entity.ChainLinkEntity;
import com.lilypuree.connectiblechains.tag.CommonTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ChainItemInfo {
    public static void chainUseEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        BlockHitResult hitResult = event.getHitVec();
        Level world = event.getLevel();
        if (player == null || player.m_6047_()) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        BlockPos blockPos = hitResult.m_82425_();
        BlockState blockState = world.m_8055_(blockPos);
        if (!ChainKnotEntity.canAttachTo(blockState)) {
            return;
        }
        if (world.f_46443_) {
            if (CommonTags.isChain(stack)) {
                event.setCanceled(true);
            }
            if (ChainKnotEntity.getHeldChainsInRange(player, blockPos).size() > 0) {
                event.setCanceled(true);
            }
            if (ChainKnotEntity.getKnotAt(player.m_9236_(), blockPos) != null && ChainLinkEntity.canDestroyWith(stack)) {
                event.setCanceled(true);
            }
            if (event.isCanceled()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        ChainKnotEntity knot = ChainKnotEntity.getKnotAt(world, blockPos);
        if (knot != null) {
            if (knot.m_6096_(player, hand) == InteractionResult.CONSUME) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
            return;
        }
        List<ChainLink> attachableChains = ChainKnotEntity.getHeldChainsInRange(player, blockPos);
        Item knotType = stack.m_41720_();
        if (attachableChains.size() == 0 && !CommonTags.isChain(stack)) {
            return;
        }
        if (!CommonTags.isChain(stack)) {
            knotType = attachableChains.get((int)0).sourceItem;
        }
        knot = new ChainKnotEntity(world, blockPos, Block.m_49814_((Item)knotType));
        knot.setGraceTicks((byte)0);
        world.m_7967_((Entity)knot);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        InteractionResult result = knot.m_6096_(player, hand);
        event.setCanceled(true);
        event.setCancellationResult(result);
    }
}

