/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.Expose;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.kir.cubeswithoutborders.client.FullscreenMode;
import dev.kir.cubeswithoutborders.client.FullscreenType;
import dev.kir.cubeswithoutborders.client.FullscreenTypes;
import dev.kir.cubeswithoutborders.client.MonitorInfo;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import dev.kir.cubeswithoutborders.client.util.ModLoaderUtil;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
class CubesWithoutBordersConfigImpl
implements CubesWithoutBordersConfig {
    public static final CubesWithoutBordersConfigImpl INSTANCE;
    private static final Gson GSON;
    private String filePath;
    @Expose
    private FullscreenMode fullscreenMode = FullscreenMode.OFF;
    @Expose
    private FullscreenMode preferredFullscreenMode = FullscreenMode.BORDERLESS;
    @Expose
    private FullscreenType fullscreenType = FullscreenTypes.exclusive();
    @Expose
    private FullscreenType borderlessFullscreenType = FullscreenTypes.borderless();
    @Expose
    private MonitorInfo preferredMonitor = MonitorInfo.primary();

    public static CubesWithoutBordersConfigImpl loadNamed(String name) {
        String fileName = name + ".json";
        String filePath = ModLoaderUtil.getConfigFolder().resolve(fileName).toString();
        return CubesWithoutBordersConfigImpl.load(filePath);
    }

    public static CubesWithoutBordersConfigImpl load(String filePath) {
        CubesWithoutBordersConfigImpl config;
        try (FileReader reader = new FileReader(filePath);){
            config = (CubesWithoutBordersConfigImpl)GSON.fromJson((Reader)reader, CubesWithoutBordersConfigImpl.class);
        }
        catch (Throwable e) {
            config = new CubesWithoutBordersConfigImpl();
        }
        config.filePath = filePath;
        return config;
    }

    @Override
    public FullscreenMode getFullscreenMode() {
        return this.fullscreenMode;
    }

    @Override
    public void setFullscreenMode(FullscreenMode fullscreenMode) {
        this.fullscreenMode = fullscreenMode;
    }

    @Override
    public FullscreenMode getPreferredFullscreenMode() {
        return this.preferredFullscreenMode;
    }

    @Override
    public void setPreferredFullscreenMode(FullscreenMode fullscreenMode) {
        this.preferredFullscreenMode = fullscreenMode;
    }

    @Override
    public FullscreenType getFullscreenType() {
        return this.fullscreenType;
    }

    @Override
    public void setFullscreenType(FullscreenType fullscreenType) {
        this.fullscreenType = fullscreenType;
    }

    @Override
    public FullscreenType getBorderlessFullscreenType() {
        return this.borderlessFullscreenType;
    }

    @Override
    public void setBorderlessFullscreenType(FullscreenType fullscreenType) {
        this.borderlessFullscreenType = fullscreenType;
    }

    @Override
    public MonitorInfo getPreferredMonitor() {
        return this.preferredMonitor;
    }

    @Override
    public void setPreferredMonitor(MonitorInfo monitor) {
        this.preferredMonitor = monitor == null ? MonitorInfo.primary() : monitor;
    }

    @Override
    public void save() {
        if (this.filePath == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.filePath);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(MonitorInfo.class, (Object)new TypeAdapter<MonitorInfo>(){

            public void write(JsonWriter out, MonitorInfo value) throws IOException {
                out.value(value.toString());
            }

            public MonitorInfo read(JsonReader in) throws IOException {
                return MonitorInfo.parse(in.nextString()).orElse(MonitorInfo.primary());
            }
        }).registerTypeAdapter(FullscreenType.class, (Object)new TypeAdapter<FullscreenType>(){

            public void write(JsonWriter out, FullscreenType value) throws IOException {
                out.value(value.id());
            }

            public FullscreenType read(JsonReader in) throws IOException {
                boolean isBorderless = in.getPath().contains("borderless");
                FullscreenType defaultFullscreenType = isBorderless ? FullscreenTypes.borderless() : FullscreenTypes.exclusive();
                return FullscreenTypes.get(in.nextString()).orElse(defaultFullscreenType);
            }
        }).create();
        INSTANCE = CubesWithoutBordersConfigImpl.loadNamed(ModLoaderUtil.getModId());
    }
}

