/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client.gui;

import de.nekeras.borderless.client.FullscreenDisplayModeHolder;
import de.nekeras.borderless.client.gui.ConfigScreenOption;
import de.nekeras.borderless.config.Config;
import de.nekeras.borderless.config.FocusLossConfig;
import de.nekeras.borderless.config.FullscreenModeConfig;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private static final String DESCRIPTION_KEY_BASE = "borderless.%s";
    private static final int LAYOUT_MAX_WIDTH = 250;
    private static final int WHITE = 0xFFFFFF;
    private static final int YELLOW = 0xFFFF00;
    private static final int RED = 0xFF0000;
    private static final int LINE_HEIGHT = 25;
    private static final Component titleText = Component.m_237115_((String)"borderless.config.title");
    private static final Component applyText = Component.m_237115_((String)"borderless.config.apply");
    private static final Component changedWarningText = Component.m_237115_((String)"borderless.config.changed");
    private static final Component disabledText = Component.m_237115_((String)"borderless.config.disabled.description");
    private static final Logger log = LogManager.getLogger();
    private final Screen parent;
    private AbstractWidget enabledButton;
    private AbstractWidget fullscreenModeButton;
    private AbstractWidget focusLossButton;

    public ConfigScreen(@Nonnull Screen parent) {
        super(titleText);
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        boolean initialEnabledState = (Boolean)Config.GENERAL.enabled.get();
        FullscreenModeConfig initialFullscreenMode = (FullscreenModeConfig)((Object)Config.GENERAL.fullscreenMode.get());
        FocusLossConfig initialFocusLossMode = (FocusLossConfig)((Object)Config.GENERAL.focusLoss.get());
        Minecraft minecraft = Minecraft.m_91087_();
        int x = this.getHorizontalLayoutStart(this.f_96543_);
        this.enabledButton = ConfigScreenOption.enabled.m_231507_(minecraft.f_91066_, x, 50, 250);
        this.fullscreenModeButton = ConfigScreenOption.fullscreenMode.m_231507_(minecraft.f_91066_, x, 75, 250);
        this.focusLossButton = ConfigScreenOption.focusLoss.m_231507_(minecraft.f_91066_, x, 100, 250);
        Button applyButton = Button.m_253074_((Component)applyText, btn -> {
            log.info("Apply button in Borderless Window Config Screen pressed");
            FullscreenDisplayModeHolder.setFullscreenDisplayModeFromConfig();
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 - 125, this.f_96544_ - 75, 100, 20).m_253136_();
        Button cancelButton = Button.m_253074_((Component)CommonComponents.f_130656_, btn -> {
            log.info("Cancel button in Borderless Window Config Screen pressed, resetting to {}, {}, {}", (Object)initialEnabledState, (Object)initialFullscreenMode, (Object)initialFocusLossMode);
            Config.GENERAL.enabled.set((Object)initialEnabledState);
            Config.GENERAL.fullscreenMode.set((Object)initialFullscreenMode);
            Config.GENERAL.focusLoss.set((Object)initialFocusLossMode);
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 + 25, this.f_96544_ - 75, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.enabledButton);
        this.m_142416_((GuiEventListener)this.fullscreenModeButton);
        this.m_142416_((GuiEventListener)this.focusLossButton);
        this.m_142416_((GuiEventListener)applyButton);
        this.m_142416_((GuiEventListener)cancelButton);
        this.refreshButtonStates();
    }

    public void m_86600_() {
        super.m_86600_();
        this.refreshButtonStates();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float frameTime) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.m_280273_(guiGraphics);
        this.renderTitle(guiGraphics, minecraft, this.f_96543_);
        this.renderDescription(guiGraphics, minecraft, this.f_96543_);
        this.renderChangedWarning(guiGraphics, minecraft, this.f_96543_, this.f_96544_);
        super.m_88315_(guiGraphics, mouseX, mouseY, frameTime);
    }

    public void m_7379_() {
        super.m_7379_();
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private void renderTitle(@Nonnull GuiGraphics guiGraphics, @Nonnull Minecraft minecraft, int width) {
        guiGraphics.m_280653_(minecraft.f_91062_, this.f_96539_, width / 2, 20, 0xFFFFFF);
    }

    private void renderDescription(@Nonnull GuiGraphics guiGraphics, @Nonnull Minecraft minecraft, int width) {
        int x = this.getHorizontalLayoutStart(width);
        int y = 125;
        if (((Boolean)Config.GENERAL.enabled.get()).booleanValue()) {
            guiGraphics.m_280554_(minecraft.f_91062_, (FormattedText)Component.m_237115_((String)this.getDescriptionKey()), x, y, 250, 0xFFFFFF);
        } else {
            guiGraphics.m_280554_(minecraft.f_91062_, (FormattedText)disabledText, x, y, 250, 0xFF0000);
        }
    }

    private void renderChangedWarning(@Nonnull GuiGraphics guiGraphics, @Nonnull Minecraft minecraft, int width, int height) {
        int x = this.getHorizontalLayoutStart(width);
        int y = height - 50;
        guiGraphics.m_280554_(minecraft.f_91062_, (FormattedText)changedWarningText, x, y, 250, 0xFFFF00);
    }

    private String getDescriptionKey() {
        FullscreenModeConfig mode = (FullscreenModeConfig)((Object)Config.GENERAL.fullscreenMode.get());
        String modeKey = String.format(DESCRIPTION_KEY_BASE, mode.name().toLowerCase());
        if (mode == FullscreenModeConfig.NATIVE) {
            FocusLossConfig focusLoss = (FocusLossConfig)((Object)Config.GENERAL.focusLoss.get());
            return String.format("%s.%s", modeKey, focusLoss.name().toLowerCase());
        }
        return modeKey;
    }

    private void refreshButtonStates() {
        boolean enabled = (Boolean)Config.GENERAL.enabled.get();
        this.enabledButton.f_93624_ = true;
        this.fullscreenModeButton.f_93624_ = enabled;
        this.focusLossButton.f_93624_ = enabled && Config.GENERAL.fullscreenMode.get() == FullscreenModeConfig.NATIVE;
    }

    private int getHorizontalLayoutStart(int width) {
        return (width - 250) / 2;
    }
}

