/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.beachparty.core.registry.RecipeRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;

public class MiniFridgeRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int craftingTime;

    public MiniFridgeRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, int craftingTime) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.craftingTime = craftingTime;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return BeachpartyUtil.matchesRecipe(inventory, this.inputs, 1, 1);
    }

    @NotNull
    public ItemStack m_5874_(Container inventory, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.MINI_FRIDGE_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.MINI_FRIDGE_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_5598_() {
        return true;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public static class Serializer
    implements RecipeSerializer<MiniFridgeRecipe> {
        @NotNull
        public MiniFridgeRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList ingredients = NonNullList.m_122779_();
            jsonArray.forEach(element -> ingredients.add((Object)Ingredient.m_43917_((JsonElement)element.getAsJsonObject())));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Mini Fridge Recipe");
            }
            if (ingredients.size() > 1) {
                throw new JsonParseException("Too many ingredients for Mini Fridge Recipe");
            }
            int craftingTime = GsonHelper.m_13824_((JsonObject)json, (String)"crafting_time", (int)100);
            JsonObject resultJson = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            return new MiniFridgeRecipe(id, (NonNullList<Ingredient>)ingredients, ShapedRecipe.m_151274_((JsonObject)resultJson), craftingTime);
        }

        @NotNull
        public MiniFridgeRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            int craftingTime = buf.m_130242_();
            return new MiniFridgeRecipe(id, (NonNullList<Ingredient>)ingredients, output, craftingTime);
        }

        public void toNetwork(FriendlyByteBuf buf, MiniFridgeRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.output);
            buf.m_130130_(recipe.craftingTime);
        }
    }
}

