/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.entity;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class PalmBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> WOOD_TYPE = SynchedEntityData.m_135353_(PalmBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PalmBoatEntity(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public PalmBoatEntity(Level level, double x, double y, double z) {
        this(EntityTypeRegistry.PALM_BOAT.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WOOD_TYPE, (Object)0);
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("Type", 8)) {
            this.setWoodType(Type.byName(pCompound.m_128461_("Type")));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("Type", this.getWoodType().getName());
    }

    public Type getWoodType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(WOOD_TYPE));
    }

    public void setWoodType(Type type) {
        this.f_19804_.m_135381_(WOOD_TYPE, (Object)type.ordinal());
    }

    @NotNull
    public Item m_38369_() {
        return this.getWoodType().getItem().get();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static enum Type {
        PALM("palm", (Supplier<Item>)ObjectRegistry.PALM_BOAT, (Supplier<Item>)ObjectRegistry.PALM_CHEST_BOAT),
        FLOATY("floaty", (Supplier<Item>)ObjectRegistry.FLOATY_BOAT, (Supplier<Item>)ObjectRegistry.FLOATY_CHEST_BOAT);

        private final String name;
        private final Supplier<Item> item;
        private final Supplier<Item> chestItem;

        private Type(String name, Supplier<Item> boatItem, Supplier<Item> chestBoatItem) {
            this.name = name;
            this.item = boatItem;
            this.chestItem = chestBoatItem;
        }

        public static Type byId(int id) {
            Type[] values = Type.values();
            if (id < 0 || id >= values.length) {
                id = 0;
            }
            return values[id];
        }

        public static Type byName(String name) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return values[0];
        }

        public ResourceLocation getTexture(boolean hasChest) {
            if (hasChest) {
                return new ResourceLocation("beachparty", "textures/entity/chest_boat/" + this.name + ".png");
            }
            return new ResourceLocation("beachparty", "textures/entity/boat/" + this.name + ".png");
        }

        public String getModelLocation() {
            return "boat/" + this.name;
        }

        public String getChestModelLocation() {
            return "chest_boat/" + this.name;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<Item> getItem() {
            return this.item;
        }

        public Supplier<Item> getChestItem() {
            return this.chestItem;
        }
    }
}

