/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.SoundEventRegistry;

public class RadioBlockEntity
extends BlockEntity {
    private static final List<SoundEvent> TRACKS = SoundEventRegistry.RADIO_SOUNDS.stream().map(Supplier::get).toList();
    private int currentIndex = -1;
    private int ticks;
    private long tickCount;
    private long startTick;
    public boolean isPlaying;
    private boolean syncedWithClient = false;

    public RadioBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.RADIO_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, RadioBlockEntity entity) {
        if (!entity.isPlaying || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (!entity.syncedWithClient) {
            entity.resendSoundToClient(server);
            entity.syncedWithClient = true;
        }
        ++entity.ticks;
        ++entity.tickCount;
        if (server.m_46467_() >= entity.startTick + 1200L) {
            entity.stop();
            return;
        }
        if (level.m_213780_().m_188501_() < 0.05f) {
            double baseX = (double)pos.m_123341_() + 0.5;
            double baseY = (double)pos.m_123342_() + 1.0;
            double baseZ = (double)pos.m_123343_() + 0.5;
            double offsetX = (level.m_213780_().m_188500_() - 0.5) * 0.6;
            double offsetZ = (level.m_213780_().m_188500_() - 0.5) * 0.6;
            float color = level.m_213780_().m_188501_();
            server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, baseX + offsetX, baseY, baseZ + offsetZ, 0, (double)color, 0.0, 0.0, 1.0);
        }
    }

    public boolean toggleOrNext() {
        if (!this.isPlaying) {
            this.start();
        } else {
            this.next(this.f_58857_);
        }
        return true;
    }

    public void start() {
        this.currentIndex = 0;
        this.play(this.f_58857_);
    }

    public void next(Level level) {
        this.currentIndex = (this.currentIndex + 1) % TRACKS.size();
        this.play(level);
    }

    public void stop() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        server.m_46796_(1011, this.f_58858_, 0);
        server.m_220407_(GameEvent.f_238649_, this.f_58858_, GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
        this.isPlaying = false;
        this.ticks = 0;
        this.tickCount = 0L;
        this.syncedWithClient = false;
    }

    private void play(Level level) {
        this.stop();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.currentIndex < 0 || this.currentIndex >= TRACKS.size()) {
            return;
        }
        this.isPlaying = true;
        this.ticks = 0;
        this.startTick = server.m_46467_();
        Item recordItem = this.getRecordItemForCurrentTrack();
        int id = Item.m_41393_((Item)recordItem);
        server.m_5898_(null, 1010, this.f_58858_, id);
        server.m_220407_(GameEvent.f_238690_, this.f_58858_, GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
        this.syncedWithClient = true;
    }

    private void resendSoundToClient(ServerLevel server) {
        Item recordItem = this.getRecordItemForCurrentTrack();
        int id = Item.m_41393_((Item)recordItem);
        server.m_5898_(null, 1010, this.f_58858_, id);
    }

    private Item getRecordItemForCurrentTrack() {
        return switch (this.currentIndex) {
            case 0 -> (Item)ObjectRegistry.MUSIC_DISC_BEACHPARTY.get();
            case 1 -> (Item)ObjectRegistry.MUSIC_DISC_CARIBBEAN_BEACH.get();
            case 2 -> (Item)ObjectRegistry.MUSIC_DISC_PRIDELANDS.get();
            case 3 -> (Item)ObjectRegistry.MUSIC_DISC_VOCALISTA.get();
            case 4 -> (Item)ObjectRegistry.MUSIC_DISC_WILD_VEINS.get();
            default -> (Item)ObjectRegistry.OVERGROWN_DISC.get();
        };
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.currentIndex = tag.m_128451_("CurrentIndex");
        this.ticks = tag.m_128451_("Ticks");
        this.tickCount = tag.m_128454_("TickCount");
        this.startTick = tag.m_128454_("StartTick");
        this.isPlaying = tag.m_128471_("IsPlaying");
        this.syncedWithClient = false;
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_("CurrentIndex", this.currentIndex);
        tag.m_128405_("Ticks", this.ticks);
        tag.m_128356_("TickCount", this.tickCount);
        tag.m_128356_("StartTick", this.startTick);
        tag.m_128379_("IsPlaying", this.isPlaying);
    }
}

