/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.beachparty.client.gui.handler.MiniFridgeGuiHandler;
import net.satisfy.beachparty.core.recipe.MiniFridgeRecipe;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.RecipeRegistry;
import net.satisfy.beachparty.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniFridgeBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<MiniFridgeBlockEntity>,
MenuProvider {
    public static final int CAPACITY = 2;
    private static final int[] SLOTS_FOR_INPUT = new int[]{1};
    private static final int[] SLOTS_FOR_OUTPUT = new int[]{0};
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 1;
    protected float experience;
    private NonNullList<ItemStack> inventory;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MiniFridgeBlockEntity.this.fermentationTime;
                case 1 -> MiniFridgeBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MiniFridgeBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    MiniFridgeBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public MiniFridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.MINI_FRIDGE_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fermentationTime = nbt.m_128451_("FermentationTime");
        this.totalFermentationTime = nbt.m_128451_("TotalFermentationTime");
        this.experience = nbt.m_128457_("Experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("FermentationTime", this.fermentationTime);
        nbt.m_128405_("TotalFermentationTime", this.totalFermentationTime);
        nbt.m_128350_("Experience", this.experience);
    }

    public void tick(Level world, BlockPos pos, BlockState state, MiniFridgeBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
        boolean dirty = false;
        MiniFridgeRecipe recipeType = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.MINI_FRIDGE_RECIPE_TYPE.get(), (Container)blockEntity, world).orElse(null);
        assert (this.f_58857_ != null);
        RegistryAccess access = this.f_58857_.m_9598_();
        if (this.canCraft(recipeType, access)) {
            if (this.fermentationTime == 0) {
                this.totalFermentationTime = recipeType.getCraftingTime();
            }
            ++this.fermentationTime;
            if (this.fermentationTime >= this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipeType, access);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private boolean canCraft(MiniFridgeRecipe recipe, RegistryAccess access) {
        if (recipe == null || recipe.m_8043_(access).m_41619_()) {
            return false;
        }
        ItemStack inputStack = this.m_8020_(1);
        ItemStack outputStack = this.m_8020_(0);
        return !inputStack.m_41619_() && (outputStack.m_41619_() || outputStack == recipe.m_8043_(access));
    }

    private void craft(MiniFridgeRecipe recipe, RegistryAccess access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(access);
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(0, recipeOutput.m_41777_());
        }
        ItemStack inputStack = this.m_8020_(1);
        inputStack.m_41774_(1);
        this.m_6836_(1, inputStack.m_41619_() ? ItemStack.f_41583_ : inputStack);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_FOR_OUTPUT;
        }
        return SLOTS_FOR_INPUT;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (slot == 1) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.m_6596_();
        }
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return slot == 1;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return ((Block)ObjectRegistry.MINI_FRIDGE.get()).m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new MiniFridgeGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

