/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public class PalmGlassPaneBlock
extends IronBarsBlock {
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)3);

    public PalmGlassPaneBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.m_5776_()) {
            this.updateAllConnected(world, pos);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)f_52313_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        if (!world.m_5776_()) {
            this.updateAllConnected(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (!world.m_5776_() && state.m_60734_() != newState.m_60734_()) {
            BlockPos up = pos.m_7494_();
            BlockPos down = pos.m_7495_();
            if (world.m_8055_(up).m_60734_() == this) {
                this.updateAllConnected(world, up);
            }
            if (world.m_8055_(down).m_60734_() == this) {
                this.updateAllConnected(world, down);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, f_52309_, f_52310_, f_52312_, f_52311_, f_52313_});
    }

    private void updateAllConnected(Level world, BlockPos start) {
        LinkedList<Vector3i> queue = new LinkedList<Vector3i>();
        HashSet<Vector3i> visited = new HashSet<Vector3i>();
        Vector3i origin = new Vector3i(start.m_123341_(), start.m_123342_(), start.m_123343_());
        queue.add(origin);
        visited.add(origin);
        while (!queue.isEmpty()) {
            Vector3i current = (Vector3i)queue.poll();
            for (Direction d : Direction.values()) {
                Vector3i next = new Vector3i(current.x + d.m_122429_(), current.y + d.m_122430_(), current.z + d.m_122431_());
                BlockPos bp = new BlockPos(next.x, next.y, next.z);
                if (world.m_8055_(bp).m_60734_() != this || visited.contains(next)) continue;
                visited.add(next);
                queue.add(next);
            }
        }
        HashMap<Long, List> columns = new HashMap<Long, List>();
        for (Vector3i v : visited) {
            long key = (long)v.x << 32 ^ (long)v.z & 0xFFFFFFFFL;
            columns.computeIfAbsent(key, k -> new ArrayList()).add(v);
        }
        for (List col : columns.values()) {
            col.sort(Comparator.comparingInt(o -> o.y));
            for (int i = 0; i < col.size(); ++i) {
                Vector3i v = (Vector3i)col.get(i);
                BlockPos bp = new BlockPos(v.x, v.y, v.z);
                BlockState s = world.m_8055_(bp);
                int size = col.size();
                int part = size == 1 ? 0 : (i == 0 ? 1 : (i == size - 1 ? 3 : 2));
                world.m_7731_(bp, (BlockState)s.m_61124_((Property)PART, (Comparable)Integer.valueOf(part)), 3);
            }
        }
    }
}

