/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.LineConnectingBlock;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;

public class HoodedBeachChair
extends LineConnectingBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", DoubleBlockHalf.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Supplier<VoxelShape> topRightShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.0, (double)0.9375, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.75, (double)0.9375, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.875, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.874375, (double)0.0, (double)0.0, (double)0.936875, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    private static final Supplier<VoxelShape> topLeftShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.75, (double)0.75, (double)1.0, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.063125, (double)0.0, (double)0.0, (double)0.125625, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_RIGHT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? topLeftShapeSupplier.get() : topRightShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    public static final Map<Direction, VoxelShape> TOP_LEFT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? topRightShapeSupplier.get() : topLeftShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    private static final Supplier<VoxelShape> topMiddleShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.75, (double)1.0, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_MIDDLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, topMiddleShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> bottomRightShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.25, (double)0.875, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.375, (double)0.25, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    private static final Supplier<VoxelShape> bottomLeftShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.25, (double)1.0, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.375, (double)0.25, (double)1.0, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_RIGHT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? bottomLeftShapeSupplier.get() : bottomRightShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    public static final Map<Direction, VoxelShape> BOTTOM_LEFT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? bottomRightShapeSupplier.get() : bottomLeftShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    private static final Supplier<VoxelShape> bottomMiddleShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.375, (double)0.25, (double)1.0, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_MIDDLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, bottomMiddleShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> topShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.8125, (double)0.0, (double)0.9375, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.75, (double)0.75, (double)0.9375, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875625, (double)0.0, (double)0.0, (double)0.938125, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.0, (double)0.875, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.063125, (double)0.0, (double)0.0, (double)0.125625, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, topShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> bottomShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.375, (double)0.25, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)1.0, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, bottomShapeSupplier.get()));
        }
    });

    public HoodedBeachChair(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockPos upperPos = pos.m_7494_();
        BlockState upperState = (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER);
        world.m_7731_(upperPos, upperState, 3);
        this.updateTypeProperty(world, pos, state);
        this.updateTypeProperty(world, upperPos, upperState);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        DoubleBlockHalf half;
        BlockPos otherPos;
        BlockState otherState;
        if (!moved && state.m_60734_() != newState.m_60734_() && (otherState = world.m_8055_(otherPos = (half = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_())).m_60734_() == this && otherState.m_61143_(HALF) != half) {
            world.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos basePos = half == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        return BeachpartyUtil.onUse(world, player, hand, new BlockHitResult(hit.m_82450_(), hit.m_82434_(), basePos, hit.m_82436_()), 0.0);
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos basePos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        return basePos.m_121878_();
    }

    @Override
    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos basePos = half == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockState baseState = world.m_8055_(basePos);
        this.updateTypeProperty(world, basePos, baseState);
        BlockPos otherPos = basePos.m_7494_();
        BlockState otherState = world.m_8055_(otherPos);
        if (otherState.m_60734_() == this) {
            world.m_7731_(otherPos, (BlockState)otherState.m_61124_((Property)TYPE, (Comparable)((Object)((BeachpartyUtil.LineConnectingType)((Object)baseState.m_61143_((Property)TYPE))))), 3);
        }
    }

    private void updateTypeProperty(Level world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BeachpartyUtil.LineConnectingType type = this.getType(state, world, pos, facing);
        if (state.m_61143_((Property)TYPE) != type) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TYPE, (Comparable)((Object)type)), 3);
        }
    }

    private BeachpartyUtil.LineConnectingType getType(BlockState state, Level world, BlockPos pos, Direction facing) {
        BlockPos leftPos;
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos rightPos = switch (facing) {
            case Direction.EAST -> {
                leftPos = pos.m_121945_(Direction.SOUTH);
                yield pos.m_121945_(Direction.NORTH);
            }
            case Direction.SOUTH -> {
                leftPos = pos.m_121945_(Direction.EAST);
                yield pos.m_121945_(Direction.WEST);
            }
            case Direction.WEST -> {
                leftPos = pos.m_121945_(Direction.NORTH);
                yield pos.m_121945_(Direction.SOUTH);
            }
            default -> {
                leftPos = pos.m_121945_(Direction.WEST);
                yield pos.m_121945_(Direction.EAST);
            }
        };
        if (half == DoubleBlockHalf.UPPER) {
            leftPos = leftPos.m_7494_();
            rightPos = rightPos.m_7494_();
        }
        BlockState leftState = world.m_8055_(leftPos);
        BlockState rightState = world.m_8055_(rightPos);
        return this.determineType(state, leftState, rightState);
    }

    private BeachpartyUtil.LineConnectingType determineType(BlockState state, BlockState leftState, BlockState rightState) {
        boolean connectLeft = this.isConnectable(state, leftState);
        boolean connectRight = this.isConnectable(state, rightState);
        if (connectLeft && connectRight) {
            return BeachpartyUtil.LineConnectingType.MIDDLE;
        }
        if (connectLeft) {
            return BeachpartyUtil.LineConnectingType.RIGHT;
        }
        if (connectRight) {
            return BeachpartyUtil.LineConnectingType.LEFT;
        }
        return BeachpartyUtil.LineConnectingType.NONE;
    }

    @Override
    protected boolean isConnectable(BlockState selfState, BlockState otherState) {
        if (otherState.m_60734_() != this) {
            return false;
        }
        return selfState.m_61143_((Property)FACING) == otherState.m_61143_((Property)FACING) && selfState.m_61143_(HALF) == otherState.m_61143_(HALF);
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos otherPos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState otherState = world.m_8055_(otherPos);
        if (otherState.m_60734_() == this && otherState.m_61143_(HALF) != half) {
            world.m_46961_(otherPos, false);
        }
        if (half == DoubleBlockHalf.UPPER && world instanceof Level) {
            Level level = (Level)world;
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.m_5456_()));
        }
        super.m_6786_(world, pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BeachpartyUtil.LineConnectingType type = (BeachpartyUtil.LineConnectingType)((Object)state.m_61143_((Property)TYPE));
        if (half == DoubleBlockHalf.UPPER) {
            return switch (type) {
                case BeachpartyUtil.LineConnectingType.RIGHT -> TOP_RIGHT_SHAPE.get(direction);
                case BeachpartyUtil.LineConnectingType.LEFT -> TOP_LEFT_SHAPE.get(direction);
                case BeachpartyUtil.LineConnectingType.MIDDLE -> TOP_MIDDLE_SHAPE.get(direction);
                default -> TOP_SHAPE.get(direction);
            };
        }
        return switch (type) {
            case BeachpartyUtil.LineConnectingType.RIGHT -> BOTTOM_RIGHT_SHAPE.get(direction);
            case BeachpartyUtil.LineConnectingType.LEFT -> BOTTOM_LEFT_SHAPE.get(direction);
            case BeachpartyUtil.LineConnectingType.MIDDLE -> BOTTOM_MIDDLE_SHAPE.get(direction);
            default -> BOTTOM_SHAPE.get(direction);
        };
    }
}

