/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class LearnGlyphCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.m_82926_(GlyphRegistry.getSpellpartMap().keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ars-glyph").requires(sender -> sender.m_6761_(2))).executes(context -> LearnGlyphCommand.learnGlyph((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_230896_()), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> LearnGlyphCommand.learnGlyph((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), null))).then(Commands.m_82129_((String)"glyph", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(sugg).executes(context -> LearnGlyphCommand.learnGlyph((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"glyph"))))));
    }

    private static int learnGlyph(CommandSourceStack source, Collection<ServerPlayer> players, @Nullable ResourceLocation glyph) {
        if (source.m_230896_() == null) {
            return 0;
        }
        for (ServerPlayer player : players) {
            IPlayerCap playerCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)player).orElse(null);
            if (glyph == null) {
                if (playerCap == null) continue;
                playerCap.setKnownGlyphs(GlyphRegistry.getSpellpartMap().values().stream().filter(g -> !g.defaultedStarterGlyph()).toList());
                player.m_213846_((Component)Component.m_237113_((String)"Unlocked all glyphs"));
            } else {
                AbstractSpellPart spellPart = GlyphRegistry.getSpellPart(glyph);
                if (spellPart.defaultedStarterGlyph()) continue;
                boolean learned = playerCap.unlockGlyph(spellPart);
                if (learned) {
                    player.m_213846_((Component)Component.m_237113_((String)("Unlocked " + spellPart.getName())));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Glyph already known"));
                }
            }
            CapabilityRegistry.EventHandler.syncPlayerCap((Player)player);
        }
        return 1;
    }
}

