/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class RitualRegistry {
    private static ConcurrentHashMap<ResourceLocation, AbstractRitual> ritualMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<ResourceLocation, RitualTablet> ritualItemMap = new ConcurrentHashMap();

    @Nullable
    public static AbstractRitual getRitual(ResourceLocation id) {
        if (!ritualMap.containsKey(id)) {
            return null;
        }
        try {
            return (AbstractRitual)ritualMap.get(id).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<ResourceLocation, AbstractRitual> getRitualMap() {
        return ritualMap;
    }

    public static Map<ResourceLocation, RitualTablet> getRitualItemMap() {
        return ritualItemMap;
    }

    public static AbstractRitual registerRitual(AbstractRitual ritual) {
        return ritualMap.put(ritual.getRegistryName(), ritual);
    }
}

