/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.caster_tools;

import alexthw.ars_elemental.api.item.ISchoolFocus;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementalCasterTome
extends CasterTome
implements ISchoolFocus {
    private final SpellSchool school;

    public ElementalCasterTome(Item.Properties properties, SpellSchool school) {
        super(properties);
        this.school = school;
    }

    @Override
    @NotNull
    public SpellSchool getSchool() {
        return this.school;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        tooltip2.add((Component)Component.m_237115_((String)"tooltip.ars_elemental.caster_tome"));
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
    }

    @Override
    public double getDiscount() {
        return 0.0;
    }

    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new CasterTome.TomeSpellCaster(stack){

            public SpellResolver getSpellResolver(SpellContext context, Level worldIn, LivingEntity playerIn, InteractionHand handIn) {
                return new ETomeResolver(context, ElementalCasterTome.this.getSchool());
            }
        };
    }

    static class ETomeResolver
    extends SpellResolver {
        private final SpellSchool school;

        public SpellSchool getSchool() {
            return this.school;
        }

        public ETomeResolver(SpellContext context, SpellSchool school) {
            super(context);
            this.school = school;
        }

        public boolean hasFocus(ItemStack stack) {
            return this.hasFocus(stack.m_41720_());
        }

        public boolean hasFocus(Item item) {
            if (item instanceof ISchoolFocus) {
                ISchoolFocus focus = (ISchoolFocus)item;
                return this.school == focus.getSchool();
            }
            if (item == ItemsRegistry.SHAPERS_FOCUS.get()) {
                return this.school == SpellSchools.MANIPULATION;
            }
            return super.hasFocus(item);
        }

        public SpellResolver getNewResolver(SpellContext context) {
            return new ETomeResolver(context, this.getSchool());
        }
    }
}

